<?php
//********************************************************************************
//Title : User Controller
//Developer:Qureshi Faizan  
//Email:qureshi@peerbits.com
//Company:Peerbits Solution
//Project:LPG Code
//Created By : Qureshi Faizan   
//Created Date : 08-May-2018
//Updated Date :
//Updated By : 
//********************************************************************************

/************************************************************************************************************************************
 *  CHANGE LOG & LATEST COMMITs : https://bitbucket.org/peerbitsrajesh/common-admin-by-rajesh/
    USER API CONTROLLER
    CREATED BY: RAJESH YADAV
    DATE : 12/06/2017

    BASE STRUCTURE FOR API COPY THIS WHENEVER WANT TO CREATE NEW API
   public function actionApiname()
    {
        /*insert all required veriables*/
        /*$required_objs = ['social_type','social_id','device_id','device_type','is_merge','is_provided_by_user'];
        /*boolean for login type to use in common function for login*/
        /*$login_type='s';


        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {

        }
        else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }*/

        /**return the result**/
        /*return $result;
    }
*************************************************************************************************************************************/

namespace app\modules\api\v1\controllers;
use Yii;
use yii\helpers\Url;
use yii\rest\ActiveController;
use yii\helpers\ArrayHelper;
use yii\filters\auth\HttpBearerAuth;
use \Exception;//to use try catch we have to import this
//use app\modules\api\v1\models\Users;
use app\models\Userdevices;
use app\models\Orderlog;
use app\models\Order;
use app\models\OrderDetail;
use app\models\Notification;
use app\models\Users;
use app\models\Userstock;
use app\models\Userstore;
use app\models\Brand;
use app\models\Bankdetail;
use app\models\Product;
use app\models\Subscription;
use app\models\UserSubscription;
use app\models\Reason;
use app\models\UserReview;
use app\models\Stock;
use app\models\Review;
use app\models\Cart;
use app\models\Contactus;
use app\models\UserAddress;
use app\models\Setting;
use yii2\web\Request;
use yii\filters\AccessControl;


class ReportController extends ActiveController
{
    /*MODEL CLASS THAT IS USED BY THIS CONTROLLER*/
    public $modelClass = 'app\modules\api\v1\models\Users';

    /*
     *WRAPPER OF THE RESPONSE JSON
     *HERE I USED "User" WRAPPER
    */
    public $serializer = [
        'class' => 'yii\rest\Serializer',
        'collectionEnvelope' => 'user',
    ];



    /***************************************************************************************************************************
     *MAIN CONFUGURATION FOR THE RESPONSE
     *formats ==> RESPONSE FORMATE OF YOUR RESPONSE
     *$behaviors['authenticator']['except'] classTHIS WILL CONTAIN APIS THAT ARE NOT USED TO TOKEN
     *$behaviors['authenticator']['class']==> AUTHENTICATION METHOD
     *KEEP YOURSELF UPDATED WITH YII2 METHODS ON behaviors
     *
    ****************************************************************************************************************************/


    public function behaviors()
    {
        $behaviors[] = [
            'class' => \yii\filters\ContentNegotiator::className(),
            'formats' => [
                'application/json' => \yii\web\Response::FORMAT_JSON,
            ],
        ];

        $behaviors['authenticator'] = [
            /*this are the api where we dont want to set up the header login data*/
            'except' => ['gettoken','getcms','generatereport',/*'login','sociallogin','register','forgotpassword' ,'resetpassword','verifyotp','resendotp','getcms','getcategories','getitems','getstores','getavailabledrivercount',*/'emailexist', 'resendemail'],
            'class' => HttpBearerAuth::className(),
             
        ];
        
        return $behaviors;
    }

     //********************************************************************************
    //Title : Get Token
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 22-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    

  

    public function actionGeneratereport(){


        die('commign in report ');
        extract($_POST);
        
        $query = Order::find()->alias('O');
        $query->where(['O.vendor_id'=>yii::$app->user->id]);
        $query->andwhere(['status'=>7]);
        $query->joinWith(['customer','vendor','add','rider']);
    

        if(isset($start_date) && $start_date!=null){
            $start=strtotime($start_date.' 00:00:00');
            $query->andFilterWhere(['>=','O.i_date',$start]);
        }
        if(isset($end_date) && $end_date!=null){
            $end=strtotime($end_date.' 23:59:59');
            $query->andFilterWhere(['<=','O.i_date',$end]);
        }
            
        $data =  $query->orderBy('i_date desc')->all();

        include Yii::getAlias('@vendor').'/PHPExcel/Classes/PHPExcel/IOFactory.php';
        include Yii::getAlias('@vendor').'/PHPExcel/Classes/PHPExcel/Writer/Excel2007.php';

        $filename='Rider_report-'.date('_d-m-Y').'.xls';
        $lastCol='E';
        $objPHPExcel = new \PHPExcel();
         $title = "Rider Report";
        if(isset($start) && $start!= null && isset($end) && $end != null){
            $title = "Rider Report - ".$start." to ".$end;
        }

        $objSheet = $objPHPExcel->getActiveSheet();
        $objSheet->setTitle('Rider_report');
        $objSheet->getStyle('A1:'.$lastCol.'1')->getFont()->setBold(true)->setSize(12);

        $objPHPExcel->setActiveSheetIndex(0);

        $rowCount = 1;
        $objPHPExcel->getActiveSheet()->getDefaultRowDimension(1)->setRowHeight(25);
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
        // $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
         
        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount,$title);
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$rowCount.':'.$lastCol.$rowCount);
        $objSheet->getStyle('A'.($rowCount))->getFont()->setBold(true);
        $rowCount++;

        $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount,'Rider info');
        $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount,'Order ID');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount,'Order passed');
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount,'Total amount received in KSH');
        $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount,'Customer info');

        // $objPHPExcel->getActiveSheet()->getStyle('A')->getAlignment()->setWrapText(true);

        $objSheet->getStyle('A'.$rowCount.':'.$lastCol.$rowCount)->getFont()->setBold(true);

        $rowCount++;
        $totalprice=0;
        
        if(isset($data) && $data!=null)
        {
            foreach ($data as $list)
            {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$rowCount,ucfirst($list->rider->user_name."\r".$rowCount,$list->rider->country_code.' '.$list->rider->mobile_number."\r".$list->rider->email));
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$rowCount,$list['id']);
          
                
                if( Orderlog::find()
                ->select(['order_id','status'])
                ->where(['order_id'=>$list->id,'status'=>2])->one())
                $status = "Yes";
                else $status = 'No';
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount,$status);

                if($list->payment_status == 'C'){
                 $recieve = $list->total_price;
                 $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount,$recieve);
                  $objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->getNumberFormat()->setFormatCode('#,##0.00');
                  $totalprice += $recieve;

                }
                else{
                    $recieve = '0';
                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount,$recieve);
                     $totalprice += $recieve;
                    
                }
                $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount,$list->add->address);
                // $objPHPExcel->getActiveSheet()->SetCellValue('E'.$rowCount,$list->customer->user_name); 
                  
                $rowCount++;
            }
        }
        // $objPHPExcel->getActiveSheet()->mergeCells('A2:C2');
        $objPHPExcel->getActiveSheet()->SetCellValue('C'.$rowCount,'Grand Total');
        $objSheet->getStyle('C'.($rowCount))->getFont()->setBold(true);
        $objPHPExcel->getActiveSheet()->SetCellValue('D'.$rowCount,$totalprice);
        $objPHPExcel->getActiveSheet()->getStyle('D'.$rowCount)->getNumberFormat()->setFormatCode('#,##0.00');
        $objSheet->getStyle('D'.($rowCount))->getFont()->setBold(true);

        $objSheet->getStyle('A1:'.$lastCol.($rowCount-1))->applyFromArray(array('borders' => array('allborders' => array('style' => \PHPExcel_Style_Border::BORDER_THIN,'color' => array('rgb' => '000')))));

        $objSheet->getStyle('A1:'.$lastCol.$rowCount)->getAlignment()->applyFromArray(array('horizontal' => \PHPExcel_Style_Alignment::HORIZONTAL_CENTER,));

        $objPHPExcel->getActiveSheet()
        ->getStyle('A2:'.$lastCol.$rowCount)
        ->getAlignment()
        ->setWrapText(true);
       
        
        
        header('Content-type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename="'.$filename.'"');
        header('Cache-Control: max-age=0');
        // header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
        header('Cache-Control: cache, must-revalidate');
        header('Pragma: public');

        // $my_excel_content = file_get_content("http://myserver/make_excel.php?parameters=...");
        // $my_excel_filename = "/tmp/".md5(session_id().microtime(TRUE)).".xls";
        // file_put_content($my_excel_filename,$my_excel_content);
        
        // $filename =Yii::getAlias('@webroot').'/report/Rider_report.xls';
        // die(var_dump($filename));

        $objWriter = \PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
    }

}

