<?php
//********************************************************************************
//Title : User Controller
//Developer:Qureshi Faizan  
//Email:qureshi@peerbits.com
//Company:Peerbits Solution
//Project:LPG Code
//Created By : Qureshi Faizan   
//Created Date : 08-May-2018
//Updated Date :
//Updated By : 
//********************************************************************************

/************************************************************************************************************************************
 *  CHANGE LOG & LATEST COMMITs : https://bitbucket.org/peerbitsrajesh/common-admin-by-rajesh/
    USER API CONTROLLER
    CREATED BY: RAJESH YADAV
    DATE : 12/06/2017

    BASE STRUCTURE FOR API COPY THIS WHENEVER WANT TO CREATE NEW API
   public function actionApiname()
    {
        /*insert all required veriables*/
        /*$required_objs = ['social_type','social_id','device_id','device_type','is_merge','is_provided_by_user'];
        /*boolean for login type to use in common function for login*/
        /*$login_type='s';


        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {

        }
        else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }*/

        /**return the result**/
        /*return $result;
    }
*************************************************************************************************************************************/

namespace app\modules\api\v2\controllers;
use Yii;
use yii\helpers\Url;
use yii\rest\ActiveController;
use yii\helpers\ArrayHelper;
use yii\filters\auth\HttpBearerAuth;
use \Exception;//to use try catch we have to import this
//use app\modules\api\v1\models\Users;
use app\models\Userdevices;
use app\models\Orderlog;
use app\models\OrderDetail;
use app\models\Order;
use app\models\Notification;
use app\models\Users;
use app\models\UserReview;
use app\models\Brand;
use app\models\Product;
use app\models\Reason;
use app\models\Review;
use app\models\Cart;
use app\models\Contactus;
use app\models\UserAddress;
use app\models\Setting;
use app\models\Vendorhistory;
use app\models\Stock;
use yii2\web\Request;
use yii\filters\AccessControl;
use app\models\Userstock;


class RiderController extends ActiveController
{
    /*MODEL CLASS THAT IS USED BY THIS CONTROLLER*/
    public $modelClass = 'app\modules\api\v1\models\Users';

    /*
     *WRAPPER OF THE RESPONSE JSON
     *HERE I USED "User" WRAPPER
    */
    public $serializer = [
        'class' => 'yii\rest\Serializer',
        'collectionEnvelope' => 'user',
    ];



    /***************************************************************************************************************************
     *MAIN CONFUGURATION FOR THE RESPONSE
     *formats ==> RESPONSE FORMATE OF YOUR RESPONSE
     *$behaviors['authenticator']['except'] classTHIS WILL CONTAIN APIS THAT ARE NOT USED TO TOKEN
     *$behaviors['authenticator']['class']==> AUTHENTICATION METHOD
     *KEEP YOURSELF UPDATED WITH YII2 METHODS ON behaviors
     *
    ****************************************************************************************************************************/


    public function behaviors()
    {
        $behaviors[] = [
            'class' => \yii\filters\ContentNegotiator::className(),
            'formats' => [
                'application/json' => \yii\web\Response::FORMAT_JSON,
            ],
        ];

        $behaviors['authenticator'] = [
            /*this are the api where we dont want to set up the header login data*/
            'except' => ['gettoken','getcms','cronjob','cronjob_old_order','unblock_riders',/*'login','sociallogin','register','forgotpassword' ,'resetpassword','verifyotp','resendotp','getcms','getcategories','getitems','getstores','getavailabledrivercount',*/'emailexist', 'resendemail'],
            'class' => HttpBearerAuth::className(),
             
        ];
        
        return $behaviors;
    }

     //********************************************************************************
    //Title : Get Token
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 22-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    public function actionGettoken()
    {

        
        extract($_POST);
        
        if(isset($device_id) && $device_id!=null && isset($device_type) && $device_type!=null)
        {
            //check device id and device type already there
            $userlogindata = Userdevices::find()->where(['device_id' => $device_id, 'device_type' => $device_type])->one();
            
            if(isset($userlogindata) && $userlogindata!=array())
            {
                //merge the data
            }
            else
            {
                $userlogindata = new Userdevices();
            }
        }
        else
        {
            $userlogindata = new Userdevices();
        }
        
        if (isset($device_id) && $device_id!=null)
            $userlogindata->device_id = $device_id;
        
        if (isset($device_type) && $device_type!=null)
            $userlogindata->device_type = $device_type;
            
        $userlogindata->user_id = '';
        $userlogindata->access_token = \Yii::$app->security->generateRandomString();
        $userlogindata->last_login_datetime = date("Y-m-d H:i:s");
        //echo "<pre>";
        //    print_r($userlogindata);die;
        if($userlogindata->save(false))
        {
            
        }
        else{
            //echo "<pre>";
            //print_r($userlogindata->getErrors());die;
        }
        $result['token']['token'] = $userlogindata->access_token;
        $result['token']['type'] = 'Bearer';
        
        return Yii::$app->apifunction->setResponse('',true,200,200,$result);

        
    }
    
    //********************************************************************************
    //Title : Update Device
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 22-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    public function actionUpdatedevice()
    {
        $required_objs = ['device_id', 'device_type'];
        
        
        /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            extract($_POST);
            $token=Yii::$app->user->identity->accessToken;
            
            
            //check device id and device type already there
            $userlogindata = Userdevices::find()->where(['access_token' => $token])->one();
            
            if(!is_object($userlogindata)){
                $userlogindata = new Userdevices();
            }
            if (isset($user_id) && $user_id!=null )
            $userlogindata->user_id = $user_id;
            
    
            if (isset($device_id) ){
                $userlogindata->device_id = $device_id;
            }
            if (isset($device_type))
                $userlogindata->device_type = $device_type;
    
            $userlogindata->save(false);
            $result['token']['token'] = $userlogindata->access_token;
            $result['token']['type'] = 'Bearer';
            
            return Yii::$app->apifunction->setResponse('',true,200,200,$result);
        }
        else
        {
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
        return $result;
        
    }
    /**************************************************************************************************************************************
     *
     COMMON API FOR LOGIN
     CREATED BY : RAJESH YADAV
     LAST UPDATAED : 15/06/2017
     CHANGE LOGS : https://bitbucket.org/peerbitsrajesh/common-admin-by-rajesh/commits/
     PULL THE LATEST STABLE VERSION FROM ABOVE URL
     PARAMS :email(USERS EMAIL ADDRESS),REQUIRED
            :password(USERS PASSWORD),REQUIRED
            :device_id(USERS DEVICE ID FOR UPDATING FOR NOTIFICATION POURPOSE),REQUIRED
            :device_type(USERS DEVICE TYPE FOR IOS OR ANDROID),REQUIRED
            :project_enviroment:(d,p // TO RESOLVE THE PEM FILE ISSUES ON SERVER AND AVOID THE BREAKDOWN)OPTIONAL(IF NOT SET THEN BY DEFAULT n)

    /*TO DOS:MAY WE NEED TO MODIFY THE checkIsPost FUNCTION DEPEND ON THE VERIABLE I AM CONSTANT IN TESTING MODE TO IMPROVISE

    ******************************************************************************************************************************************/

    //********************************************************************************
    //Title : Login
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 22-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    public function actionLogin()
    {
        
        
        //insert all required veriables
        $required_objs = ['mobile_number','password', 'device_id', 'device_type'];
        $login_type='n';
        
        /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            //convert post veriables to keynames
            extract($_POST);
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}

           
            //$data = Users::find()->where(['is_deleted'=>'N','password'=>md5($password),'country_code'=>$country_code,'user_type'=>["U"],"contact_number"=>$contact_number])->one();
            //$data = Users::find()->where(['is_deleted'=>'N','password'=>md5($password),'email'=>$email,'user_type'=>["U"]])->one();
            $data = Yii::$app->apifunction->getUserDetailOnPassword($mobile_number,$password,'R');
            

            if(isset($data) && $data != array())
            {
                switch ($data) {
                    case $data->is_active=='N':
                    $result_code = 803;
                    break;
                    default:
                    $result_code = 200;
                }
                
                /*if from admin panel the user is not activated then  we will show this below message*/
                if($result_code==803 || $result_code==802 || $result_code==801)
                {
                    //$result['message'] = Yii::t('app',Yii::$app->params['account_deactivate']);
                    return Yii::$app->apifunction->setResponse('account_deactivate',false,200,400);
                    //Yii::$app->getResponse()->setStatusCode(400);
                    
                }
                if($data->is_deleted=="Y")
                {
                   return Yii::$app->apifunction->setResponse('account_deleted_message',false,200,400);
                }
                // if($data->mobile_verified=="N")
                // {
                //    return Yii::$app->apifunction->setResponse('phone_verification_pending',false,200,400);
                // }
                //if(isset($data->email) && $data->email!=null)
                //{
                //    if($data->email_verified=="N")
                //    {
                //        return Yii::$app->apifunction->setResponse('email_verification_pending',false,200,400);
                //    }
                //}
                
                    $data->last_active = time();
                    $data->save(false);

                //set device and device type to access token
                $token_result = Yii::$app->apifunction->manageToken($data->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                
                
                /*common code for login device updation is also there*/

                /**
                 * I have to remove all old token of this rider
                 */

                // Userdevices::deleteAll('access_token <> :access_token', [':access_token' => Yii::$app->user->identity->accessToken]);


                $result = Yii::$app->apifunction->apiLogin($data, $device_id, $device_type, $login_type,'',false);
                return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
               // $result["token"] = Yii::$app->apifunction->Userlogintocken($data->id, $device_id, $device_type);
                return $result;
            }else
            {
                return Yii::$app->apifunction->setResponse('invalid_login_1',false,200,400);
            }
        }
        else
        {

            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }

        return $result;
    }

    /*=============================================================================================================================================
     Created by :
     Date : 30/06/2017
     API Name : Social signup
     TO DO :
     Tested : not yet
     RESPONSE TIME:

     PARAMS :   SOCIALID(REQUIRED),
                SOCIALTYPE(REQUIRED)(F,G),
                NAME,
                EMAIL,
                IMAGE URL,
                ISPROVIDEDBYUSER(IS EMAIL PROVIDED BY USER)(REQUIRED),
                ISMERGE(REQUIRED),
                DEVICEID,
                DEVICETYPE,



     ALGORITHM :- STEP 1 : CHECK SOCIAL ID IS EXIST OR NOT
                  STEP 2 : IF EXIST THEN LOGIN
                  STEP 3 : CHECK EMAIL IS PROVIDED OR NOT
                  STEP 4 : IF NOT EMAIL 404 EMAIL NOT FOUND(line 191,195)
                  STEP 5 : IF EMAIL FOUND AND ALREADY REGISTERED

    ================================================================================================================================================*/
    //********************************************************************************
    //Title : Social Login (MObile Mandatory)
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 22-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionSocialloginmobile()
    {
        //insert all required veriables
        //$required_objs = ['social_type','social_id'/*,'device_id','device_type'*/,'is_merge','is_provided_by_user'];
        $required_objs = ['social_type','social_id','is_merge','is_provided_by_user'];
        /*boolean for login type to use in common function for login*/
        $login_type='s';//S=SOCIAL,n=normal
        /*to by pass login or send verification email*/
        $login_imidiatly = 'n';
        $result['is_mobile_required']='n';
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            /*extract the post veiables*/
            extract($_POST);
            $is_merge = \strtolower($is_merge);
            $is_provided_by_user = \strtolower($is_provided_by_user);
            $social_type = strtolower($social_type);
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}

            /*algorith step :1,2 check social id exists or not and proceed for next*/
            $user_obj =Yii::$app->apifunction->getUserDetailFromSocialId($social_type,$social_id);


            if($user_obj != array())
            {
                $token_result = Yii::$app->apifunction->manageToken($user_obj->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                $result = Yii::$app->apifunction->apiLogin($user_obj,$device_id,$device_type,$social_type,$is_merge,false);
                
                if(\strtolower($social_type) =='f' && $user_obj->is_facebook_verified =='N' ){
                    return Yii::$app->apifunction->setResponse('phone_found_but_account_not_verified',true,200,400,$result);
                }
                if (\strtolower($social_type) == 't' && $user_obj->is_twitter_verified == 'N') {
                    return Yii::$app->apifunction->setResponse('phone_found_but_account_not_verified', true, 200,400,$result);
                }
                if (\strtolower($social_type) == 'g' && $user_obj->is_google_verified == 'N') {
                    return Yii::$app->apifunction->setResponse('phone_found_but_account_not_verified', true, 200,400,$result);
                }
                return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
                /*common code for login device updation is alos there*/
                

                return $result;
            }

            /*ALGORITHM STEP 3 BEGINS, USER IS NOT REGISTERED FIRST TIME HERE*/
            //if(isset($email) && $email != null)
            if(isset($country_code) && $country_code != null && isset($contact_number) && $contact_number != null)
            {
                /*check user obj*/
                //$user_obj_from_email = Yii::$app->apifunction->getUserDetailOnEmail($email,'u');
                $user_obj_from_phone=$data = Users::find()->where(['is_deleted'=>'N','country_code'=>$country_code,'user_type'=>["U"],"contact_number"=>$contact_number])->one();

                if($user_obj_from_phone)
                {
                    if($user_obj_from_phone->is_active =='n')
                    {
                        /*here need to check that user is deactivated or not*/
                        return Yii::$app->apifunction->setResponse('phone_foun_but_account_deactivate',false,200,400);
                    }
                    //$email_data = Users::find()->where(['is_deleted'=>'N','email'=>$email,'user_type'=>["U"]])->one();
                    //if(isset($email_data) && $email_data != array())
                    //    return Yii::$app->apifunction->setResponse('email_exist_already',false, 200, 400);

                    /*email found now check is merge*/
                    if($is_merge =='n')
                    {
                        $result['is_merge']='y';
                        return Yii::$app->apifunction->setResponse('phone_registered_want_merge',true,200,400,$result);
                    
                    }elseif($is_merge =='y')
                    {

                        /*user want to merge the account, check email provided by user or not*/
                        if(isset($is_provided_by_user) && $is_provided_by_user == 'n')
                        {
                            $login_imidiatly = 'y';
                        }
                        if ($social_type == 'i') {
                            $user_obj_from_phone->instagram_id = $social_id;
                            $user_obj_from_phone->instagram_token=md5($social_id);
                            $token=$user_obj_from_phone->instagram_token;
                            if ($login_imidiatly == 'y') {
                                $user_obj_from_phone->is_instagram_verified = 'Y';
                                $user_obj_from_phone->mobile_verified = 'Y';
                            }

                        } else if($social_type == 't') {
                            $user_obj_from_phone->twitter_id = $social_id;
                            $user_obj_from_phone->twitter_token=md5($social_id);
                            $token=$user_obj_from_phone->twitter_token;
                            if ($login_imidiatly == 'y') {
                                $user_obj_from_phone->is_twitter_verified = 'Y';
                                $user_obj_from_phone->mobile_verified = 'Y';
                            }
                        }
                        else if($social_type == 'f') {
                            $user_obj_from_phone->facebook_id = $social_id;
                            $user_obj_from_phone->facebook_token=md5($social_id);
                            $token=$user_obj_from_phone->facebook_token;
                            if($login_imidiatly=='y')
                            {
                                $user_obj_from_phone->is_facebook_verified = 'Y';
                                $user_obj_from_phone->mobile_verified = 'Y';
                            }
                        }
                        else{
                            $user_obj_from_phone->google_id = $social_id;
                            $user_obj_from_phone->google_token=md5($social_id);
                            $token=$user_obj_from_phone->google_token;
                            if($login_imidiatly=='y')
                            {
                                $user_obj_from_phone->is_google_verified = 'Y';
                                $user_obj_from_phone->mobile_verified = 'Y';
                            }
                        }
                        //echo "<pre>";
                        //print_r($user_obj);die;
                        $user_obj_from_phone->email_verified = 'Y';
                        if(isset($email) && $email!=null)
                        {
                            $user_obj_from_phone->email = isset($email) ? $email : "";
                            $user_obj_from_phone->email_verified = 'N';
                        }
                        //if($user_obj_from_phone->first_name==null)
                        $user_obj_from_phone->first_name = isset($fullname) ? $fullname : "";
                        
                        //if($user_obj_from_phone->image==null)
                        $user_obj_from_phone->image = isset($profile_image) ? $profile_image : "";
                        if(isset($_FILES['profile_image']['tmp_name']) && $_FILES['profile_image']['tmp_name'] != null)
                        {
                            $image = $_FILES['profile_image']['name'];
                            $tmp = $_FILES['profile_image']['tmp_name'];
                            $ext = substr(strrchr($image, "."), 1);
                            $fileName = md5(rand() * time()) . ".$ext";
                            $user_obj_from_phone->image = Yii::$app->common->Uploadimageonbucket($fileName,$tmp);
                        }
                        
                        $user_obj_from_phone->save(false);
                        if(isset($email) && $email!=null)
                        {
                            $link=Url::to("@web/site/useremailverification?args=".$token."&type=".strtoupper($social_type),true);
                            Yii::$app->common->sendemail($user_obj_from_phone->email,$user_obj_from_phone->first_name,$link,'emailverify');
                            $user_obj_from_phone->email_verified = 'N';
                        }
                        else
                            $user_obj_from_phone->email_verified = 'Y';
                        
                        if($login_imidiatly=='n')
                        {
                            $otp=Yii::$app->common->generate_otp_code();
                            $user_obj_from_phone->otp=$otp;
    
                            //Yii::$app->common->sendsms($user_obj_from_phone->country_code.$user_obj_from_phone->contact_number,'Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp);
                            if(isset($user_obj_from_phone->email) && $user_obj_from_phone->email!=null)
                            {
                                $content='Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp;
                                Yii::$app->common->otpemail($user_obj_from_phone->email,$user_obj_from_phone->user_name,$content,'otp_mail');
                            }
                                
                            $user_obj_from_phone->mobile_verified = 'N';
                            //$user_obj_from_phone->email_verified = 'N';
                            $user_obj_from_phone->save(false);
                        }
                        //echo "here";die;
                        $token_result = Yii::$app->apifunction->manageToken($user_obj_from_phone->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                        $result = Yii::$app->apifunction->apiLogin($user_obj_from_phone, $device_id, $device_type, $social_type,'N',false);
                        return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
                        //if($login_imidiatly=='y'){
                        //    return Yii::$app->apifunction->apiLogin($user_obj_from_phone,$device_id,$device_type,$login_type,$is_merge);
                        //}
                        //$send_verification = Yii::$app->apifunction->sendVerificationEmail($user_obj_from_phone,$social_type);
                        
                        //if($send_verification == true)
                        //{
                        //    return Yii::$app->apifunction->setResponse('email_send_verification',false,505);
                        //}else{
                        //    return Yii::$app->apifunction->setResponse('error_in_saving_data',false,500);
                        //}
                    }

                }else{

                    /*no email found create new user*/
                    $user_obj = new Users();
                    //print_r($user_obj);;exit;
                    if($social_type =='g')
                    {
                        $user_obj->google_id = $social_id;
                        $user_obj->google_token=md5($social_id);
                        $token=$user_obj->google_token;
                        if(isset($is_provided_by_user) && $is_provided_by_user == 'n')
                        {
                            $user_obj->is_google_verified = 'Y';
                            $user_obj->mobile_verified = 'Y';
                        }
                    }
                    if($social_type =='f')
                    {
                        $user_obj->facebook_id = $social_id;
                        $user_obj->facebook_token=md5($social_id);
                        $token=$user_obj->facebook_token;
                        if(isset($is_provided_by_user) && $is_provided_by_user == 'n')
                        {
                            $user_obj->is_facebook_verified = 'Y';
                            $user_obj->mobile_verified = 'Y';
                        }
                    }
                    $email_data = Users::find()->where(['is_deleted'=>'N','email'=>$email,'user_type'=>["U"]])->one();
                    if(isset($email_data) && $email_data != array())
                        return Yii::$app->apifunction->setResponse('email_exist_already',false, 200, 400);
                    
                    $user_obj->email_verified = 'Y';
                    if(isset($email) && $email!=null)
                    {
                        $user_obj->email = isset($email) ? $email : "";
                        $user_obj->email_verified = 'N';
                    }
                    $user_obj->first_name = isset($fullname) ? $fullname : "";
                    
                    $user_obj->image = isset($profile_image) ? $profile_image : "";
                    if(isset($_FILES['profile_image']['tmp_name']) && $_FILES['profile_image']['tmp_name'] != null)
                    {
                        $image = $_FILES['profile_image']['name'];
                        $tmp = $_FILES['profile_image']['tmp_name'];
                        $ext = substr(strrchr($image, "."), 1);
                        $fileName = md5(rand() * time()) . ".$ext";
                        $user_obj->image = Yii::$app->common->Uploadimageonbucket($fileName,$tmp);
                    }
                    $user_obj->country_code = isset($country_code) ? $country_code : "";
                    $user_obj->contact_number = isset($contact_number) ? $contact_number : "";

                    /*belo 3 lines will be automaticaly saved*/
                    $user_obj->user_type = 'U';
                    // $user_obj->i_date = date('Y-m-d H:i:s');
                    // $user_obj->u_date = date('Y-m-d H:i:s');
                    $user_obj->i_date = time();
                    $user_obj->u_date = time();

                    /*IF DATA ARE NOT SAVED THEN SEND THE IMIDIATE ERRROR*/
                    if(!$user_obj->save(false))
                    {
                        return Yii::$app->apifunction->setResponse('error_in_saving_data',false,200,400);
                    }
                    /*email is provided by user_error and merge , so email verification is required*/
                        //$send_verification = Yii::$app->apifunction->sendVerificationEmail($user_obj,$social_type);
                    if(isset($email) && $email!=null)
                    {
                        $link=Url::to("@web/site/useremailverification?args=".$token."&type=".strtoupper($social_type),true);
                        Yii::$app->common->sendemail($user_obj->email,$user_obj->first_name,$link,'emailverify');
                        $user_obj->email_verified = 'N';
                    }
                    else
                        $user_obj->email_verified = 'Y';
                    $user_obj->i_by = $user_obj->id;
                    $user_obj->u_by = $user_obj->id;
                    $user_obj->save(false);
                    if(isset($is_provided_by_user) && \strtolower($is_provided_by_user) == 'y')
                    {
                                                
                        $otp=Yii::$app->common->generate_otp_code();
                        $user_obj->otp=$otp;

                        //Yii::$app->common->sendsms($user_obj->country_code.$user_obj->contact_number,'Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp);
                        if(isset($user_obj->email) && $user_obj->email!=null)
                        {
                            $content='Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp;
                            Yii::$app->common->otpemail($user_obj->email,$user_obj->user_name,$content,'otp_mail');
                        }
                        $user_obj->mobile_verified = 'N';
                        //$user_obj->email_verified = 'N';
                        $user_obj->save(false);
                        
                        //if($send_verification == true)
                        //{
                        //    return Yii::$app->apifunction->setResponse('email_send_verification',false,505);
                        //}else{
                        //    return Yii::$app->apifunction->setResponse('error_in_saving_data',false,500);
                        //}
                    }
                    //set device and device type to access token
                    $token_result = Yii::$app->apifunction->manageToken($user_obj->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                    $result = Yii::$app->apifunction->apiLogin($user_obj, $device_id, $device_type, $social_type,'N',false);
                        return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
                    //elseif(isset($is_provided_by_user) && \strtolower($is_provided_by_user) == 'n') {
                    //    /*email is not provided by user so merge account and login imidiatly*/
                    //    return Yii::$app->apifunction->apiLogin($user_obj,$device_id,$device_type,$login_type);
                    //}
                }
            }else{
                /*step : 4 from algo*/
                $result['is_mobile_required']='y';
                return Yii::$app->apifunction->setResponse('phone_required',true,200,200,$result);
            }
        }
        else{
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
        /*return the result*/
       // return $result;
    }
    //********************************************************************************
    //Title : Social Login (Email Mandatory)
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 23-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionSociallogin()
    {
        //insert all required veriables
        //$required_objs = ['social_type','social_id'/*,'device_id','device_type'*/,'is_merge','is_provided_by_user'];
        $required_objs = ['social_type','social_id','is_merge','is_provided_by_user'];
        /*boolean for login type to use in common function for login*/
        $login_type='s';//S=SOCIAL,n=normal
        /*to by pass login or send verification email*/
        $login_imidiatly = 'n';
        $result['is_email_required']='n';
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            /*extract the post veiables*/
            extract($_POST);
            $is_merge = \strtolower($is_merge);
            $is_provided_by_user = \strtolower($is_provided_by_user);
            $social_type = strtolower($social_type);
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}

            /*algorith step :1,2 check social id exists or not and proceed for next*/
            $user_obj =Yii::$app->apifunction->getUserDetailFromSocialId($social_type,$social_id);


            if($user_obj != array())
            {
                $token_result = Yii::$app->apifunction->manageToken($user_obj->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                $result = Yii::$app->apifunction->apiLogin($user_obj,$device_id,$device_type,$social_type,$is_merge,false);
                
                if(\strtolower($social_type) =='f' && $user_obj->is_facebook_verified =='N' ){
                    return Yii::$app->apifunction->setResponse('phone_found_but_account_not_verified',true,200,400,$result);
                }
                if (\strtolower($social_type) == 't' && $user_obj->is_twitter_verified == 'N') {
                    return Yii::$app->apifunction->setResponse('phone_found_but_account_not_verified', true, 200,400,$result);
                }
                if (\strtolower($social_type) == 'g' && $user_obj->is_google_verified == 'N') {
                    return Yii::$app->apifunction->setResponse('phone_found_but_account_not_verified', true, 200,400,$result);
                }
                return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
                /*common code for login device updation is alos there*/
                

                return $result;
            }

            /*ALGORITHM STEP 3 BEGINS, USER IS NOT REGISTERED FIRST TIME HERE*/
            //if(isset($email) && $email != null)
            if(isset($email) && $email != null )
            {
                /*check user obj*/
                //$user_obj_from_email = Yii::$app->apifunction->getUserDetailOnEmail($email,'u');
                $user_obj_from_phone=$data = Users::find()->where(['is_deleted'=>'N','email'=>$email,'user_type'=>["U"]])->one();
                
                if($user_obj_from_phone)
                {
                    if($user_obj_from_phone->is_active =='n')
                    {
                        /*here need to check that user is deactivated or not*/
                        return Yii::$app->apifunction->setResponse('email_found_but_account_deactivate',false,200,400);
                    }
                    //$email_data = Users::find()->where(['is_deleted'=>'N','email'=>$email,'user_type'=>["U"]])->one();
                    //if(isset($email_data) && $email_data != array())
                    //    return Yii::$app->apifunction->setResponse('email_exist_already',false, 200, 400);

                    /*email found now check is merge*/
                    if($is_merge =='n')
                    {
                        $result['is_merge']='y';
                        return Yii::$app->apifunction->setResponse('email_registered_want_merge',true,200,400,$result);
                    
                    }
                    elseif($is_merge =='y')
                    {

                        /*user want to merge the account, check email provided by user or not*/
                        if(isset($is_provided_by_user) && $is_provided_by_user == 'n')
                        {
                            $login_imidiatly = 'y';
                        }
                        if ($social_type == 'i') {
                            $user_obj_from_phone->instagram_id = $social_id;
                            $user_obj_from_phone->instagram_token=md5($social_id);
                            $token=$user_obj_from_phone->instagram_token;
                            if ($login_imidiatly == 'y') {
                                $user_obj_from_phone->is_instagram_verified = 'Y';
                                $user_obj_from_phone->email_verified = 'Y';
                            }

                        } else if($social_type == 't') {
                            $user_obj_from_phone->twitter_id = $social_id;
                            $user_obj_from_phone->twitter_token=md5($social_id);
                            $token=$user_obj_from_phone->twitter_token;
                            if ($login_imidiatly == 'y') {
                                $user_obj_from_phone->is_twitter_verified = 'Y';
                                $user_obj_from_phone->email_verified = 'Y';
                            }
                        }
                        else if($social_type == 'f') {
                            $user_obj_from_phone->facebook_id = $social_id;
                            $user_obj_from_phone->facebook_token=md5($social_id);
                            $token=$user_obj_from_phone->facebook_token;
                            if($login_imidiatly=='y')
                            {
                                $user_obj_from_phone->is_facebook_verified = 'Y';
                                $user_obj_from_phone->email_verified = 'Y';
                            }
                        }
                        else{
                            $user_obj_from_phone->google_id = $social_id;
                            $user_obj_from_phone->google_token=md5($social_id);
                            $token=$user_obj_from_phone->google_token;
                            if($login_imidiatly=='y')
                            {
                                $user_obj_from_phone->is_google_verified = 'Y';
                                $user_obj_from_phone->email_verified = 'Y';
                            }
                        }
                        //echo "<pre>";
                        //print_r($user_obj);die;
                        $user_obj_from_phone->email = isset($email) ? $email : "";
                        //if($user_obj_from_phone->first_name==null)
                        $user_obj_from_phone->first_name = isset($fullname) ? $fullname : "";
                        
                        //if($user_obj_from_phone->last_name==null)
                        //$user_obj_from_phone->last_name = isset($last_name) ? $last_name : "";
                        //if($user_obj_from_phone->image==null)
                        $user_obj_from_phone->image = isset($profile_image) ? $profile_image : "";
                        if(isset($_FILES['profile_image']['tmp_name']) && $_FILES['profile_image']['tmp_name'] != null)
                        {
                            $image = $_FILES['profile_image']['name'];
                            $tmp = $_FILES['profile_image']['tmp_name'];
                            $ext = substr(strrchr($image, "."), 1);
                            $fileName = md5(rand() * time()) . ".$ext";
                            //$user_obj_from_phone->image = Yii::$app->common->Uploadimageonbucket($fileName,$tmp);
                        }
                        
                        $user_obj_from_phone->save(false);
                        
                        
                        if($login_imidiatly=='n')
                        {
                            if(isset($email) && $email!=null)
                            {
                                $first_name='User';
                                if(isset($user_obj_from_phone->first_name) && $user_obj_from_phone->first_name!=null)
                                    $first_name=$user_obj_from_phone->first_name;
                                    
                                $link=Url::to("@web/site/useremailverification?args=".$token."&type=".strtoupper($social_type),true);
                                Yii::$app->common->sendemail($user_obj_from_phone->email,$first_name,$link,'emailverify');
                                $user_obj_from_phone->email_verified = 'N';
                            }
                            else
                                $user_obj_from_phone->email_verified = 'Y';
                            //$user_obj_from_phone->email_verified = 'N';
                            $user_obj_from_phone->save(false);
                        }
                        //echo "here";die;
                        $token_result = Yii::$app->apifunction->manageToken($user_obj_from_phone->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                        $result = Yii::$app->apifunction->apiLogin($user_obj_from_phone, $device_id, $device_type, $social_type,'N',false);
                        return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
                        //if($login_imidiatly=='y'){
                        //    return Yii::$app->apifunction->apiLogin($user_obj_from_phone,$device_id,$device_type,$login_type,$is_merge);
                        //}
                        //$send_verification = Yii::$app->apifunction->sendVerificationEmail($user_obj_from_phone,$social_type);
                        
                        //if($send_verification == true)
                        //{
                        //    return Yii::$app->apifunction->setResponse('email_send_verification',false,505);
                        //}else{
                        //    return Yii::$app->apifunction->setResponse('error_in_saving_data',false,500);
                        //}
                    }

                }else{

                    /*no email found create new user*/
                    $user_obj = new Users();
                    //print_r($user_obj);;exit;
                    if($social_type =='g')
                    {
                        $user_obj->google_id = $social_id;
                        $user_obj->google_token=md5($social_id);
                        $token=$user_obj->google_token;
                        if(isset($is_provided_by_user) && $is_provided_by_user == 'n')
                        {
                            $user_obj->is_google_verified = 'Y';
                            $user_obj->email_verified = 'Y';
                        }
                    }
                    if($social_type =='f')
                    {
                        $user_obj->facebook_id = $social_id;
                        $user_obj->facebook_token=md5($social_id);
                        $token=$user_obj->facebook_token;
                        if(isset($is_provided_by_user) && $is_provided_by_user == 'n')
                        {
                            $user_obj->is_facebook_verified = 'Y';
                            $user_obj->email_verified = 'Y';
                        }
                    }
                    //$email_data = Users::find()->where(['is_deleted'=>'N','email'=>$email,'user_type'=>["U"]])->one();
                    //if(isset($email_data) && $email_data != array())
                    //    return Yii::$app->apifunction->setResponse('email_exist_already',false, 200, 400);
                    $user_obj->email = isset($email) ? $email : "";
                    $user_obj->first_name = isset($fullname) ? $fullname : "";
                    //$user_obj->last_name = isset($last_name) ? $last_name : "";
                    $user_obj->image = isset($profile_image) ? $profile_image : "";
                    
                    
                    if(isset($_FILES['profile_image']['tmp_name']) && $_FILES['profile_image']['tmp_name'] != null)
                    {
                        $image = $_FILES['profile_image']['name'];
                        $tmp = $_FILES['profile_image']['tmp_name'];
                        $ext = substr(strrchr($image, "."), 1);
                        $fileName = md5(rand() * time()) . ".$ext";
                        //$user_obj->image = Yii::$app->common->Uploadimageonbucket($fileName,$tmp);
                    }
                    //$user_obj->country_code = isset($country_code) ? $country_code : "";
                    //$user_obj->contact_number = isset($contact_number) ? $contact_number : "";

                    /*belo 3 lines will be automaticaly saved*/
                    $user_obj->user_type = 'U';
                    // $user_obj->i_date = date('Y-m-d H:i:s');
                    // $user_obj->u_date = date('Y-m-d H:i:s');

                    $user_obj->i_date = time();
                    $user_obj->u_date = time();

                    /*IF DATA ARE NOT SAVED THEN SEND THE IMIDIATE ERRROR*/
                    if(!$user_obj->save(false))
                    {
                        return Yii::$app->apifunction->setResponse('error_in_saving_data',false,200,400);
                    }
                    /*email is provided by user_error and merge , so email verification is required*/
                        //$send_verification = Yii::$app->apifunction->sendVerificationEmail($user_obj,$social_type);
                    
                    $user_obj->i_by = $user_obj->id;
                    $user_obj->u_by = $user_obj->id;
                    $user_obj->save(false);
                    if(isset($is_provided_by_user) && \strtolower($is_provided_by_user) == 'y')
                    {
                                                    
                        if(isset($email) && $email!=null)
                        {
                            $first_name='User';
                            if(isset($user_obj->first_name) && $user_obj->first_name!=null)
                                $first_name=$user_obj->first_name;
                            $link=Url::to("@web/site/useremailverification?args=".$token."&type=".strtoupper($social_type),true);
                            Yii::$app->common->sendemail($user_obj->email,$first_name,$link,'emailverify');
                            $user_obj->email_verified = 'N';
                            
                        }
                        else
                            $user_obj->email_verified = 'Y';
                        
                        //if($send_verification == true)
                        //{
                        //    return Yii::$app->apifunction->setResponse('email_send_verification',false,505);
                        //}else{
                        //    return Yii::$app->apifunction->setResponse('error_in_saving_data',false,500);
                        //}
                    }
                    //set device and device type to access token
                    $token_result = Yii::$app->apifunction->manageToken($user_obj->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                    $result = Yii::$app->apifunction->apiLogin($user_obj, $device_id, $device_type, $social_type,'N',false);
                        return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
                    //elseif(isset($is_provided_by_user) && \strtolower($is_provided_by_user) == 'n') {
                    //    /*email is not provided by user so merge account and login imidiatly*/
                    //    return Yii::$app->apifunction->apiLogin($user_obj,$device_id,$device_type,$login_type);
                    //}
                }
            }else{
                /*step : 4 from algo*/
                $result['is_email_required']='y';
                return Yii::$app->apifunction->setResponse('email_required',true,200,200,$result);
            }
        }
        else{
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
        /*return the result*/
       // return $result;
    }




    /***********************************************************************************************************************************
        API FOR Register
        CREATED BY :RAJESH YADAV
        DATE : 14/07/2017
        MODIFIED DATE :
        TESTED : NOT YET
    ***********************************************************************************************************************************/
    //********************************************************************************
    //Title : Register
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 22-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionRegister()
    {
        
        /**insert all required veriables*/
        $required_objs = ['password','full_name','email','mobile_number','device_id','device_type','country_code'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            extract($_POST);
            // $data = Yii::$app->apifunction->getUserDetailOnEmail($email,'u');
            $data = Yii::$app->apifunction->getUserDetailOnMobile($country_code,$mobile_number,'R');
            

            if(!empty($email))
            {
                
                $data = Yii::$app->apifunction->getUserDetailOnEmail($email,'U');
                // $contact_data = Yii::$app->apifunction->getUserDetailOnMobile($_POST['country_code'],$_POST['mobile_number'],'u');
                if(isset($data) && $data != array())
                    return Yii::$app->apifunction->setResponse('Email already exist',false, 200, 400);
            }
            
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}
            if(!isset($dob)){$dob=null;}
            if($data == null)
            {
            
                if(isset($_POST['country_code']) && $_POST['country_code']!=null && isset($_POST['mobile_number']) && $_POST['mobile_number']!=null  )
                {
                    
                    
                    $contact_data = Yii::$app->apifunction->getUserDetailOnMobile($_POST['country_code'],$_POST['mobile_number'],'u');
                    if(isset($contact_data) && $contact_data != array())
                        return Yii::$app->apifunction->setResponse('phone_exist_already',false, 200, 400);
                }
                
                $user = new Users();
                
                //$user->username = $_POST['name'];
                if(isset($full_name) && $full_name != null)
                    $user->user_name = $_POST['full_name'];
                    
                if(isset($last_name) && $last_name != null)
                    $user->last_name = $_POST['last_name'];
                
                $user->email_verified = 'Y';//if email is optional
                if(isset($_POST['email']) && $_POST['email']!=null) 
                {
                    $user->email = $_POST['email'];
                    $user->email_verified = 'N';
                }
                $user->mobile_verified = 'Y'; //if mobile is optional
                if(isset($_POST['country_code']) && $_POST['country_code']!=null && isset($_POST['mobile_number']) && $_POST['mobile_number']!=null  )
                {
                    $user->country_code = $_POST['country_code'];
                    $user->mobile_number = $_POST['mobile_number'];
                    $user->mobile_verified = 'N';
                }
                $user->password = md5($_POST['password']);

                /*REMOVE IF YOU ARE SAVING globally SAVE METHOD*/
                $user->user_type = 'U';
                
                // $user->i_date = date('Y-m-d H:i:s');
                // $user->u_date = date('Y-m-d H:i:s');

                $user->i_date = time();
                $user->u_date = time();

                $user->dob = $dob;
                $user->save(false);
                $user->i_by = $user->id;
                $user->u_by = $user->id;
                $user->email_verification_token = Yii::$app->apifunction->randomstring($user->id);
                $otp=Yii::$app->common->generate_otp_code();
                $user->otp=$otp;
                
                
                if(isset($_POST['country_code']) && $_POST['country_code']!=null && isset($_POST['mobile_number']) && $_POST['mobile_number']!=null  )
                {
                    $content='Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp;
                    Yii::$app->common->sendsms($user->country_code.$user->mobile_number,$content);
                    if(isset($user->email) && $user->email!=null)
                        Yii::$app->common->otpemail($user->email,$user->user_name,$content,'otp_mail');
            
                    $user->mobile_verified = 'N';
                }

                if($user->save(false))
                {
                    ///*send mail via common code you can send via your default code too*/
                    //Yii::$app->apifunction->sendMail('Email Verification', $user->email_id, array('username' => $user->first_name, 'link' => $link), 'verifyemail');
                    if(isset($_POST['email']) && $_POST['email']!=null)
                    {
                        $link=Url::to("@web/site/useremailverification?args=".$user->email_verification_token."&type=N",true);
                        Yii::$app->common->sendemail($user->email,$user->user_name,$link,'emailverify');
                    }
                    //set device and device type to access token
                    $token_result = Yii::$app->apifunction->manageToken($user->id, $device_id, $device_type,Yii::$app->user->identity->accessToken);
                    ///*set the response code*/
                    $result = Yii::$app->apifunction->apiLogin($user, $device_id, $device_type, '','',false);
                    return Yii::$app->apifunction->setResponse('verification_email_sent', true, 200,200,$result);

                }

            }
            else
            {
                return Yii::$app->apifunction->setResponse('phone_exist_already',false, 200, 400);
            }
        }
        else
        {
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
        return $result;
    }


    

    /***********************************************************************************************************************************
        API FOR Forgotpassword
        CREATED BY :INDRA SHASTRI
        DATE : 14/07/2017
        MODIFIED DATE :
        TESTED : NOT YET
    ***********************************************************************************************************************************/
    //********************************************************************************
    //Title : Forgot M-PIN
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 08-May-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionForgotmpin()
    {
        $required_objs = ['mobile_number'];

        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            extract($_POST);
           
            $data = Yii::$app->apifunction->getUserDetailOnMobileForMpin($mobile_number,'R');

            if(isset($data) && $data!=array())
            {
                $mPIN = Yii::$app->common->generate_otp_code();
                $data->password = md5($mPIN);

                if($data->save(false))
                {
                    $content='Welcome to '.Yii::$app->params['appName'].', Your new M-PIN number is :'.$mPIN;
                    Yii::$app->common->sendsms($data->country_code.$data->mobile_number,$content);

                    if(isset($data->email) && $data->email!=null)
                        Yii::$app->common->otpemail($data->email,$data->user_name,$content,'otp_mail');
                    
                    return Yii::$app->apifunction->setResponse('success_mpin',true,200,200);
                    
                }
                else
                {
                    return Yii::$app->apifunction->setResponse('error_in_update',false,200,400);
                }
            }
            else
            {
                return Yii::$app->apifunction->setResponse('error_mobile_not_found',false,200,400);
            }
        }
        else
        {
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
    }

    

    /***********************************************************************************************************************************
        API FOR Logout
        CREATED BY :RAJESH YADAV
        DATE : 14/07/2017
        MODIFIED DATE :
        TESTED : NOT YET
    ***********************************************************************************************************************************/

    public function actionLogout()
    {
        /*insert all required veriables*/
        $required_objs = [];
        if (Yii::$app->apifunction->CheckAuthToken()) {
            if (Yii::$app->apifunction->checkIsPost($required_objs, $_POST)) {
                extract($_POST);
                Yii::$app->apifunction->updateAccessTockentoNull(Yii::$app->user->identity->accessToken);
                //$result = Yii::$app->apifunction->setResponse('success', true, 200);
                //$result["message"] = Yii::t('app', Yii::$app->params["success_logout"]);
                return Yii::$app->apifunction->setResponse('success_logout',true,200,400);
                return $result;
            } else {
                return Yii::$app->apifunction->setResponse('response_text',false,200,400);
            }
        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }


    }


    /***********************************************************************************************************************************
        API FOR Changepassword
        CREATED BY :RAJESH YADAV
        DATE : 14/07/2017
        MODIFIED DATE :
        TESTED : NOT YET
    ***********************************************************************************************************************************/
    //********************************************************************************
    //Title : Change Password
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG Code
    //Created By : Qureshi Faizan   
    //Created Date : 07-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionChangempin()
    {
        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['old_pin','new_pin'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
            
            extract($_POST);
            $userid = Yii::$app->user->id;
            $model = Users::findOne($userid);
            if(isset($model) && $model!=array())
            {

                if($model->is_active=='N')
                {
                    return Yii::$app->apifunction->setResponse('user_deactivated',false,200,400);
                }

                // die(var_dump(md5($model->password)));
                if(md5($old_pin) != $model->password)
                {
                    return Yii::$app->apifunction->setResponse('incorrect_old_mpin',false,200,400);
                }
    
                if(md5($old_pin) == md5($new_pin))
                {
                    return Yii::$app->apifunction->setResponse('same_old_mpin',false,200,400);
                }
    
    
                /****save details*****/
                $model->password = md5($new_pin);
                $model->save(false);
                /***if want to send the email*/
                //try{
                //     Yii::$app->apifunction->sendMail(Yii::$app->params['mail_subject_for_password_changed'],$model->email,array('username' => $model->first_name,'link'=>''),'passwordchanged');
                //}catch(Exception $e) {
                //    //hope you dont need to uncomment below
                //    //print $e
                //}
    
    
                return Yii::$app->apifunction->setResponse('mpin_changed',true,200,200);
            }
            else{
                return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);
            }

        }
        else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
        /**return the result**/
        return $result;
    }
    //********************************************************************************
    //Title : Resend OTP
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG
    //Created By : Qureshi Faizan   
    //Created Date : 23-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionResendotp()
    {
        $required_objs = ['country_code','mobile_number'];
         /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if (Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs, $_POST)) {
            extract($_POST);
            if(isset(Yii::$app->user->identity->id) && Yii::$app->user->identity->id!=null) //for logged user (while change mobile number)
                $data= Users::find()->select('*')->where(['is_deleted'=>'N','id'=>Yii::$app->user->identity->id,"mobile_number"=>$mobile_number])->one();
            else // for guest user
                $data= Users::find()->where(['is_deleted'=>'N','country_code'=>$country_code,'user_type'=>$user_type,"mobile_number"=>$mobile_number])->one();
            if(isset($data) && $data!=array())
            {
                
                $random_str = time().rand(10000,99999);
                $data->forgot_password_token = md5($random_str);

                // set forgot password token timeout, set to 1 hour from now
                $data->forgot_password_token_timeout = time();
                $otp=Yii::$app->common->generate_otp_code();
                $data->otp=$otp;
                if($data->save(false))
                {
                    //send sms to user mobile number
                    
                    Yii::$app->common->sendsms($data->country_code.$data->mobile_number,'Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp);;
                    
                    if(isset($data->email) && $data->email!=null)
                    {
                        $content='Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp;
                        Yii::$app->common->otpemail($data->email,$data->user_name,$content,'otp_mail');
                    }
                    return Yii::$app->apifunction->setResponse('forgot_password_sms_resent',true,200,200);
                }
                else
                {
                    return Yii::$app->apifunction->setResponse('error_forgot_password',false,200,400);
                }
            }
            else
            {
                return Yii::$app->apifunction->setResponse('error_forgot_password_id_not_found',false,200,400);
            }
        } else {
            return Yii::$app->apifunction->setResponse('response_text', false, 400, 400);
        }
    }
    /***********************************************************************************************************************************
        API FOR VERIFY OTP
        CREATED BY :RAJESH YADAV
        DATE : 14/07/2017
        MODIFIED DATE :
        TESTED : NOT YET
    ***********************************************************************************************************************************/

    //********************************************************************************
    //Title : Verify OTP
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG
    //Created By : Qureshi Faizan   
    //Created Date : 23-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionVerifyotp()
    {
        //insert all required veriables
        $required_objs = ['otp','country_code','mobile_number'];
        $login_type='n';

        /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}
            //convert post veriables to keynames
            extract($_POST);
            //$userid = Yii::$app->user->id;
            if(isset(Yii::$app->user->identity->id) && Yii::$app->user->identity->id!=null)
                $data= Users::find()->select('*')->where(['is_deleted'=>'N','id'=>Yii::$app->user->identity->id])->one();
            else
                $data= Users::find()->select('*')->where(['is_deleted'=>'N','country_code'=>$country_code,'user_type'=>'U',"mobile_number"=>$mobile_number])->one();
            if(isset($data) && $data != array())
            {
                if($data->otp == $otp)
                {
                    $data->mobile_verified = 'Y';
                    $data->save(false);
                    
                    return Yii::$app->apifunction->setResponse('mobile_verified_successfully',true,200,200);    
                    // if($type=='f')//forgot password
                    // {
                    // return Yii::$app->apifunction->setResponse('mobile_verified_successfully',true,200,200);                            
                    // }
                    // if($type=='e')//From edit profile need to change new phone number
                    // {
                    //     //$model= Users::find()->select('*')->where(['is_deleted'=>'N','id'=>Yii::$app->user->identity->id])->one();
                    //     $data->country_code = $country_code;
                    //     $data->contact_number = $contact_number;
                    //     $data->u_by = Yii::$app->user->identity->id;
                    //     $data->u_date = date('Y-m-d H:i:s');
                    //     $data->save(false);
                    //     $result = Yii::$app->apifunction->apiLogin($data,$device_id, $device_type, '','',false);
                    //     return Yii::$app->apifunction->setResponse('mobile_verified_successfully',true,200,200,$result);
                    // }
                    // else 
                    // {
                    //     $result = Yii::$app->apifunction->apiLogin($data,$device_id, $device_type, '','',false);
                    //     return Yii::$app->apifunction->setResponse('mobile_verified_successfully',true,200,200,$result);
                    // }                    
                }else{
                    return Yii::$app->apifunction->setResponse('mobile_verification_mismatch',false,200,400);
                }
            }else{
               return Yii::$app->apifunction->setResponse('error_forgot_password_id_not_found',false,200,400);
            }
        }
        else
        {
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
        return $result;
    }
    //********************************************************************************
    //Title : Resend Email
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG
    //Created By : Qureshi Faizan   
    //Created Date : 23-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************
    public function actionResendemail()
    {
        $required_objs = ['email'];
         /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if (Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs, $_POST))
        {
            extract($_POST);
            $data = Yii::$app->apifunction->getUserDetailOnEmail($email,'U');
            if(isset($data) && $data!=array())
            {
                $token=$type=''; 
                
                if(isset($_REQUEST['social_type']) && $_REQUEST['social_type']=='f')
                {
                  $type='F';
                  $data->facebook_token=md5($data->facebook_id);
                  $token=$data->facebook_token;
                  /*NEED TO CHECK FOR ALREADY VERIFIED I.E IF ALREADY VERIFIED*/
                }
                else if(isset($_REQUEST['social_type']) && $_REQUEST['social_type']=='g')
                {
                  $type='G';
                  $data->google_token=md5($data->google_id);
                  $token=$data->google_token;
                  /*NEED TO CHECK FOR ALREADY VERIFIED I.E IF ALREADY VERIFIED*/
                }
                else
                {
                    $type='N';//N for normal user(without social)
                    
                    /*NEED TO CHECK FOR ALREADY VERIFIED I.E IF ALREADY VERIFIED*/
                    
                    $data->email_verification_token=md5($data->id);
                    $token=$data->email_verification_token;
                }
                $data->save(false);
                $msg=Yii::$app->params['verification_link_sent'];
                $link=Url::to("@web/site/useremailverification?args=".$token."&type=".$type,true);
                Yii::$app->common->sendemail($data->email,$data->user_name,$link,'emailverify');
                return Yii::$app->apifunction->setResponse('resend_email',true,200,200);
            }
            else
            {
                
             return Yii::$app->apifunction->setResponse('error_forgot_password_id_not_found',false,200,400);
            }
            
        }
        else
        {
            return Yii::$app->apifunction->setResponse('response_text', false, 400, 400);
        }
    }
    //********************************************************************************
    //Title : Get CMS Page
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG
    //Created By : Qureshi Faizan   
    //Created Date : 23-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    public function actionGetcms()
    {
        $required_objs = [];
         /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if (Yii::$app->apifunction->checkIsPost($required_objs, $_POST))
        {
            $result['terms_and_conditions']=Url::to("@web/site/terms?type=R",true);
            $result['privacy_policy']=Url::to("@web/site/privacy_policy?type=R",true);
            $result['faqs']=Url::to("@web/site/faq?type=R",true);
            $result['about_us']=Url::to("@web/site/about?type=R",true);
                
            return Yii::$app->apifunction->setResponse('',true,200,200,$result);
        }
        else
        {
            return Yii::$app->apifunction->setResponse('response_text', false, 400, 400);
        }

        
        return $result;
    }
    
    //********************************************************************************
    //Title : Get Profile
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG
    //Created By : Qureshi Faizan   
    //Created Date : 07-02-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    public function actionGetprofile()
    {
        $required_objs = ['user_id'];
         /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
        if (Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs, $_POST))
    {
            extract($_POST);
            $userid = Yii::$app->user->id;
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            $data = Users::find()->where(['id'=>$user_id,'is_deleted'=>'N'])->one();
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}
            
            if(isset($data) && $data != array())
            {
                
                if($data->is_active =='N')
                {
                    return Yii::$app->apifunction->setResponse('account_deactivate',false,200,400);
                }
            
                $result = Yii::$app->apifunction->apiLogin($data, $device_id, $device_type, '','',false);
                
                return Yii::$app->apifunction->setResponse('welcome_login',true,200,200,$result);
    
            }else{
                return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);
    
            }
        }
        else
    {
            return Yii::$app->apifunction->setResponse('response_text', false, 400, 400);
        }
        return $result;
    }
    /***********************************************************************************************************************************
        API FOR UPDATE PROFILE
        CREATED BY :RAJESH YADAV
        DATE : 14/07/2017
        MODIFIED DATE :
        TESTED : NOT YET
    ***********************************************************************************************************************************/
    //********************************************************************************
    //Title : Edit Profile
    //Developer: Qureshi Faizan 
    //Email:qureshi@peerbits.com
    //Company:Peerbits Solution
    //Project:LPG
    //Created By : Qureshi Faizan   
    //Created Date : 08-May-2018
    //Updated Date : 
    //Updated By : 
    //********************************************************************************

    public function actionUpdateprofile()
    {
        
        extract($_POST);
        $userid = Yii::$app->user->id;
        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        $data = Users::find()->where(['id'=>$userid,'is_deleted'=>'N'])->one();

        
        if(isset($data) && $data != array())
        {
            if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}
            if($data->is_active =='N')
            {
                return Yii::$app->apifunction->setResponse('account_deactivate',false,200,400);
            }
            
            
            if(isset($_POST['email']))
            {
                if(empty($_POST['email']))
                {
                    $data->email='';
                }
                $check_email= Yii::$app->common->checkemail($_REQUEST['email'],$data->id,'U');
                if($check_email > 0)
                {
                    
                    return Yii::$app->apifunction->setResponse('email_exist_already',false,200,400);
                }
                if($data->email!=$_POST['email'] && !empty($_POST['email']))
                {
                    
                    $random_str = time().rand(10000,99999);
                    $data->email_verification_token = md5($random_str);
                    $link=Url::to("@web/site/useremailverification?args=".$data->email_verification_token."&type=N",true);
                    Yii::$app->common->sendemail($_REQUEST['email'],$data->user_name,$link,'emailverify');
                    $data->email_verified = 'N';
                }
                $data->email = $_POST['email'];
            }
            if(isset($_POST['first_name']) && $_POST['first_name'] != '')
            $data->first_name = $_POST['first_name'];
            
            if(isset($_POST['dob']) && $_POST['dob'] != ''   )
            $data->dob = $_POST['dob'];
            
            if(isset($_POST['full_name']) && $_POST['full_name'] != ''   )
            $data->user_name = $_POST['full_name'];
            
            if(isset($_POST['country_code']) && $_POST['country_code'] != '' && isset($_POST['mobile_number']) && $_POST['mobile_number'] != '')
            {
                
                $check_email= Yii::$app->common->checkmobile($_REQUEST['country_code'],$_POST['mobile_number'],$data->id,'U');
                if($check_email > 0){
                    return Yii::$app->apifunction->setResponse('phone_exist_already',false,200,400);
                }
                
                if($data->country_code!=$_POST['country_code'] || $data->mobile_number!=$_POST['mobile_number'] )
                {
                    
                    $otp=Yii::$app->common->generate_otp_code();
                    $data->otp=$otp;
                    $data->country_code = $_POST['country_code'];
                    $data->mobile_number = $_POST['mobile_number'];
                    
                    //Yii::$app->common->sendsms($data->country_code.$data->contact_number,'Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp);;
                    if(isset($data->email) && $data->email!=null)
                    {
                        $content='Welcome to '.Yii::$app->params['appName'].', One Time Password(OTP) to verify your phone number is :'.$otp;
                        Yii::$app->common->otpemail($data->email,$data->user_name,$content,'otp_mail');
                    }
                    $data->mobile_verified = 'N'; 
                }
                
            }
            if(isset($_FILES['profile_image']['tmp_name']) && $_FILES['profile_image']['tmp_name'] != null)
            {
                $image = $_FILES['profile_image']['name'];
                $tmp = $_FILES['profile_image']['tmp_name'];
                $ext = substr(strrchr($image, "."), 1);
                $fileName = md5(rand() * time()) . ".$ext";

                /**
                 * Unlink or delete the previouse image from server
                 */
                if($data->image != null && file_exists(Yii::getAlias('@webroot').'/'.$data->image))
                {
                    unlink(Yii::getAlias('@webroot')."/".$data->image);
                }

                $data->image = Yii::$app->apifunction->normalUpload($_FILES['profile_image'],yii::$app->params['user_direcotry']);
            }
            
            //update driver detail
            
            
            $data->u_by = $data->id;
            // $data->u_date = date('Y-m-d H:i:s');
            $data->u_date = time();
            $data->save(false);
            
            $result = Yii::$app->apifunction->apiLogin($data, $device_id, $device_type, 'e','',false);
            
            return Yii::$app->apifunction->setResponse('profile_successfully_updated',true,200,200,$result);

        }else{
            return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);

        }
        return $result;
    }
    
    /*API FOR CLEAR BADGE*/
    
    public function actionClearbadge()
    {
        
        extract($_POST);
        
        $userid = Yii::$app->user->id;
        $badgeCount = (isset($badge_count) && $badge_count!= "") ? $badge_count : 0;
        $data = Users::find()->where(['id'=>$userid,'is_deleted'=>'N'])->one();
        if(!isset($device_id)){$device_id=null;}
            if(!isset($device_type)){$device_type=null;}
        
        if(isset($data) && $data != array())
        {
            Yii::$app->apifunction->clearbadge($userid,$badgeCount);
        }
        return Yii::$app->apifunction->setResponse('success',true,200,200);
    }

    public function actionContactus()
    {
        $required_objs = ['subject','message'];
        /*CHECK REQUIRED POST VERIABLES WITH VALUES*/
       if (Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs, $_POST))
        {
            extract($_POST);
            $userid = Yii::$app->user->id;
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            $data = Users::find()->where(['id'=>$userid,'is_deleted'=>'N'])->one();

            if(isset($data) && $data != array())
            {
                if(!isset($device_id)){$device_id=null;}
                if(!isset($device_type)){$device_type=null;}
                if($data->is_active =='N')
                {
                    return Yii::$app->apifunction->setResponse('account_deactivate',false,200,400);
                }
            
            $contactus = new Contactus();
            $contactus->i_by = $data->id;
            $contactus->subject = $subject;
            $contactus->message = $message;
            $contactus->first_name =  $data->user_name;
            $contactus->last_name = '';
            $contactus->phone_number =  $data->country_code.' '. $data->mobile_number;
            $contactus->email =  $data->email;
            $contactus->send_by = 'R';
            $contactus->i_date = time();

            if($contactus->save(false))
            {
                return Yii::$app->apifunction->setResponse(Yii::$app->params['thanks_feedback'],true,200,200);     
            }
           
       }else{
            return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);

        }
    }else{
            return Yii::$app->apifunction->setResponse('response_text',false,200,400);
        }
    }

    public function actionChangemobilenumber()
    {
        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['mobile_number','country_code'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
            
            extract($_POST);
            $userid = Yii::$app->user->id;
            $model = Users::findOne($userid);
            if(isset($model) && $model!=array())
            {

                if($model->is_active=='N')
                {
                    return Yii::$app->apifunction->setResponse('user_deactivated',false,200,400);
                }
                
                /**
                * Save new Mobile number
                */
    
                $model->country_code = $country_code;
                $model->mobile_number = $mobile_number;
                
                // $model->mobile_verified = 'N';

                $model->save(false);
                /***if want to send the email*/
                //try{
                //     Yii::$app->apifunction->sendMail(Yii::$app->params['mail_subject_for_password_changed'],$model->email,array('username' => $model->first_name,'link'=>''),'passwordchanged');
                //}catch(Exception $e) {
                //    //hope you dont need to uncomment below
                //    //print $e
                //}
    
    
                return Yii::$app->apifunction->setResponse('mobile_number_changed',true,200,200);
            }
            else{
                return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);
            }

        }
        else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
        /**return the result**/
        return $result;
    }

    public function actionNotificationsetting(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['is_online'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
            
            extract($_POST);
            $userid = Yii::$app->user->id;
            $model = Users::findOne($userid);
            if(isset($model) && $model!=array())
            {

                if($model->is_active=='N')
                {
                    return Yii::$app->apifunction->setResponse('user_deactivated',false,200,400);
                }

                /**
                 * Here i have to check if his profile if his profile is not approved then 
                 * dont provide him online status channg abilty
                 */

                if($model->profile_status != 'A'){
                    return Yii::$app->apifunction->setResponse('Your account is pending approval',false,200,400);                    
                }
                
                if(!in_array($is_online,['Y','N']))
                {
                    return Yii::$app->apifunction->setResponse('error_notification',false,200,400);
                }
  
  
                if(isset($is_online) && $is_online !=null)
                    $model->notification_enabled = $is_online;
            
                if(isset($is_online) && $is_online !=null)
                    $model->is_online = $is_online;
  
                //now save record in database
                if($model->save(false)){
                    $message = $model->notification_enabled == 'N'?Yii::$app->params['success_notification_offline']:Yii::$app->params['success_notification_online'];
                        return Yii::$app->apifunction->setResponse($message,true,200,200);
                    }
           
                
            }else{
                return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);
            }

        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
      }//Notification settings end here

      public function actionAddeditaddress(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['full_name','mobile_number','country_code','house_number','estate','area','landmark','address','zipcode','is_default','latitude','longitude'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
            
            extract($_POST);

            if(isset($address_id) && $address_id!= null)
            {
                $model = UserAddress::findOne($address_id);
                $model->full_name = isset($full_name)?$full_name:'';
                $model->mobile_number = isset($mobile_number)?$mobile_number:'';
                $model->country_code = isset($country_code)?$country_code:'';
                $model->house_number = isset($house_number)?$house_number:'';
                $model->estate = isset($estate)?$estate:'';
                $model->area = isset($area)?$area:'';
                $model->landmark = isset($landmark)?$landmark:'';
                $model->address = isset($address)?$address:'';
                $model->zipcode = isset($zipcode)?$zipcode:'';
                $model->is_default = isset($is_default)?$is_default:'';
                $model->latitude = isset($latitude)?$latitude:'';
                $model->longitude = isset($longitude)?$longitude:'';
                $model->u_by = yii::$app->user->id;
                $model->u_date = time();
  
                //now save record in database
                if($model->save(false)){
                        return Yii::$app->apifunction->setResponse('address_update_successfully',true,200,200);
                    }
           
                
            }else{
                $model = new UserAddress();
                $model->full_name = isset($full_name)?$full_name:'';
                $model->user_id = yii::$app->user->id;
                $model->mobile_number = isset($mobile_number)?$mobile_number:'';
                $model->country_code = isset($country_code)?$country_code:'';
                $model->house_number = isset($house_number)?$house_number:'';
                $model->estate = isset($estate)?$estate:'';
                $model->area = isset($area)?$area:'';
                $model->landmark = isset($landmark)?$landmark:'';
                $model->address = isset($address)?$address:'';
                $model->zipcode = isset($zipcode)?$zipcode:'';
                $model->is_default = isset($is_default)?$is_default:'';
                $model->latitude = isset($latitude)?$latitude:'';
                $model->longitude = isset($longitude)?$longitude:'';
                $model->i_by = yii::$app->user->id;
                $model->i_date = time();
                if($model->save(false)){
                    return Yii::$app->apifunction->setResponse('address_update_successfully',true,200,200);
                }
            }

        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
      }//AddEdtiAddress end here

      public function actionAddresslist()
      {
          $required_objs = [];
          Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
          
          extract($_POST);
          //check if user exist or not
          //$data = Yii::$app->apifunction->getUserDetailOnEmail($email,'u');
          
          $addresses = UserAddress::find()->where(['user_id'=>yii::$app->user->id,'is_deleted'=>'N']);
          
  
              $start = isset($_REQUEST['start']) ? $_REQUEST['start'] : 0  ;
              $limit  = isset($_REQUEST['limit'])  ? $_REQUEST['limit']+1  : 11 ;
              $addresses = $addresses->offset($start)->limit($limit);
           
            
            $addresses = $addresses->all();
  
              if(isset($addresses) && $addresses!=array())
              {
                  $i = 0;
                  foreach($addresses as $key => $address){
                      
                      $result['address_list'][$i]['id'] = $address->id;
                      $result['address_list'][$i]['full_name'] = $address->full_name?$address->full_name:'';
                      $result['address_list'][$i]['mobile_number'] = $address->mobile_number?$address->mobile_number:'';
                      $result['address_list'][$i]['country_code'] = $address->country_code?$address->country_code:'';
                      $result['address_list'][$i]['house_number'] = $address->house_number?$address->house_number:'';
                      $result['address_list'][$i]['estate'] = $address->estate?$address->estate:'';
                      $result['address_list'][$i]['area'] = $address->area?$address->area:'';
                      $result['address_list'][$i]['landmark'] = $address->landmark?$address->landmark:'';
                      $result['address_list'][$i]['address'] = $address->address?$address->address:'';
                      $result['address_list'][$i]['zipcode'] = $address->zipcode?$address->zipcode:'';
                      $result['address_list'][$i]['is_default'] = $address->is_default?$address->is_default:'';
                      $result['address_list'][$i]['i_date'] = $address->i_date;
                      $result['address_list'][$i]['u_date'] = $address->u_date?$address->u_date:'';
                      $i++;
                    }
                    $result['is_last'] ='Y';
                    if($i > $limit){
                        unset($result['address_list'][$i-1]);
                        $result['is_last'] ='N';
                    }
                    return Yii::$app->apifunction->setResponse('address_list',true,200,200,$result);
                    
                }else
                {
                    $result['address_list'] = [];
                  return Yii::$app->apifunction->setResponse('error_address_list_not_found',false,200,400,$result);
              }
      }//Address list end here

      public function actionDeleteaccount(){

            $this->layout=false;
            /*insert all required veriables*/
            $required_objs = [];

            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
            
            extract($_POST);
            $userid = Yii::$app->user->id;
            $model = Users::findOne($userid);
            if(isset($model) && $model!=array())
            {

                    $model->is_deleted = 'Y';
  
                //now save record in database
                if($model->save(false)){
                        return Yii::$app->apifunction->setResponse('account_deleted',true,200,200);
                    }
           
                
            }else{
                return Yii::$app->apifunction->setResponse('error_user_not_found',false,200,400);
            }
      }//delete account  end here

    public function actionBrandlist(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = [];

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

        //Lets first get the all brand list
        $brand = Brand::find()->where(['is_deleted'=>'N']);

        $start = isset($start) ? $start : 0  ;
        $limit  = isset($limit)  ? $limit+1  : 11 ;
        $brand = $brand->offset($start)->limit($limit);
        
        $brand = $brand->all();

        if($brand){
          $i=0;
          
          foreach ($brand as $key => $value) {
          $result['brand_list'][$i]['id']    = $value->id;
          $result['brand_list'][$i]['brand_name']  = $value->brand_name?$value->brand_name:'';
          $result['brand_list'][$i]['brand_image'] = $value->brand_image?Url::to('@web/'.$value->brand_image,true):'';
          $i++;
          }

          $result['is_last'] ='Y';
  
          if(isset($_REQUEST['limit']) && $_REQUEST['limit'] !=null){
                if($i >= $limit){
                    unset($result['brand_list'][$i-1]);
                    $result['is_last'] ='N';
                }
              }
          return Yii::$app->apifunction->setResponse('success_brand_list',true,200,200,$result);
              
        }else{
            $result['brand_list'] = [];            
            return Yii::$app->apifunction->setResponse('error_no_brand_list',false,200,400,$result);
        }
  }//Brand list end here

    public function actionNotificationlist(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = [];

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

        $notification = Notification::find()->where(['type'=>['R','A']])->all();

        $userId = yii::$app->user->id;
        
      //Now based on UserId check the reciver ids,if found then store its id(notification)
      $notification_ids = array();
      foreach ($notification as $key => $value) {
        $reciver_ids = explode(',', $value->to_user);
        $deleted_ids = explode(',', $value->deleted_by);
        if(in_array($userId,$reciver_ids) && !in_array($userId,$deleted_ids))
              $notification_ids[] = $value->id;
      }
       //Now get those ids data
       $notification = Notification::find()->where(['id'=>$notification_ids]);
  
       $start = isset($start) ? $start : 0  ;
       $limit  = isset($limit)  ? $limit+1  : 11 ;
       $notification = $notification->offset($start)->limit($limit);

      
       $notification = $notification->orderBy('id DESC')->all();


        if($notification){
            $i = 0;
        foreach ($notification as $key => $value) {

        $result['notification_list'][$i]['id'] = $value->id;
        $result['notification_list'][$i]['message']  = $value->message?$value->message:'';
        $result['notification_list'][$i]['type'] = $value->notification_type;
        $result['notification_list'][$i]['order_id'] = $value->order_id?$value->order_id:'';
        $result['notification_list'][$i]['timestamp'] = $value->i_datetime;
        $i++;
        }

        $result['is_last'] ='Y';

        if($i >= $limit){
            unset($result['notifications'][$i-1]);
            $result['is_last'] ='N';
        }
        return Yii::$app->apifunction->setResponse('success_notification_list',true,200,200,$result);

        }else{
            $result['notification_list'] = [];           
        return Yii::$app->apifunction->setResponse('error_no_notificatin_not_found',true,200,200,$result);   
        }
    }//Notification list end here



    public function actionClearnotificationlist(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = [];

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

        //Lets first get the all notification list

        $notification = Notification::find()->where(['type'=>['R','A']])->all();

        $userId = yii::$app->user->id;
        $userid[] = $userId;

        //Now based on UserId check the reciver ids,if found then store its id(notification)
        $notification_ids = array();
        foreach ($notification as $key => $value)
        {
            $reciver_ids = explode(',', $value->to_user);
            $deleted_ids = explode(',', $value->deleted_by);
            $deleted_id = explode(',', $value->deleted_by);
            if(in_array($userId,$reciver_ids) && !in_array($userId,$deleted_ids))
                $notification_ids[] = $value->id;
        }
    
        //Now get those ids data
        $notification = Notification::find()->where(['id'=>$notification_ids])->all();
        if(!$notification)
        {
            return Yii::$app->apifunction->setResponse('allready_clear_notification',false,200,400);     
        }
        else
        {
            foreach ($notification as $key => $value)
            {

                $deletedid =  array_merge($deleted_id,$userid);
                $value->deleted_by =implode(',',$deletedid);
                $value->save(false);
            }
            return Yii::$app->apifunction->setResponse('clear_notification',true,200,200);     
        }

    }//Clear notification end here

    public function actionCancelorder(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['order_id'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
             
            extract($_POST);
            $userId = yii::$app->user->id;
            
            $order_log = Orderlog::find()->where(['order_id'=>$order_id,'status'=>'9'])->one();
            if($order_log){
                return Yii::$app->apifunction->setResponse('allready_cancel',false,200,400);                 
            }
            

            $order = Order::find()->where(['id'=>$order_id])->one();
            if(!$order){
                return Yii::$app->apifunction->setResponse('error_order_not_found',false,200,400);                 
            }
            $old_status = $order->status;
            $order->status='9';


            OrderDetail::updateAll(['status' => '9'], ['order_id' => $order_id]);

            if(!empty($reason_id)){
            $reason = Reason::find()->where(['id'=>$reason_id])->one();      
            $order->cancellation_reason = $reason->reason;
            }elseif(!empty($message)){
                $order->cancellation_reason = $message;
            }

            if($order->save(false))
            {
              
              /**
               * Bring the vendor products count in it actula state
               */
              if($old_status != 1){
              $order_details = OrderDetail::find()->where(['order_id'=>$order->id])->all();
              foreach($order_details as $details){
                  $stock = Stock::find()->where(['user_id'=>$order->vendor_id,'product_id'=>$details->product_id])->one();
                  $stock->quantity = $stock->quantity + $details->quantity;
                  $stock->sold_out = $stock->sold_out - $details->quantity;
                  $stock->save(false);
              }
            }

              /** 
               * send cancel notification to user as well as his vendor 
               */
              $noti = new Notification;
              $noti->from_user = Yii::$app->user->id;

              $both_ids[] = $order->user_id;
              $both_ids[] = $order->vendor_id;

              $noti->to_user = implode(',',$both_ids);

              $noti->notification_type = 'cancel_status_rider';
              $noti->message = "Order cancelled due to \"$order->cancellation_reason\"";
              $noti->order_id = $order_id;
              $noti->type = 'A';
              
              $noti->i_by = Yii::$app->user->id;
              $noti->i_date = date('Y-m-d H:i:s');
              $noti->i_datetime = time();
              $noti->save(false);

              $body_a=array();
              $body_a['data']['notification_type'] = 'cancel_status_rider';
              $body_a['data']['order_id'] = $order->id;
              $body_a['data']['status'] = $order->status;
              $body_a['data']['is_accepted'] = 'N';
              
              $body_a['data']['master_id'] = $order->id;
              $body_a['data']['message'] = "Order cancelled due to \"$order->cancellation_reason\"";

              $body_i=array();
              $body_i['data'] = array('alert' =>"Order cancelled due to \"$order->cancellation_reason\"");
              $body_i['data']['badge'] = 1;
              $body_i['data']['order_id'] = $order->id;
              $body_i['data']['master_id'] = $order->id;
              $body_i['data']['status'] = $order->status;
              $body_i['data']['notification_type'] = 'cancel_status_rider';
              $body_i['data']['sound'] = 'RequestNotification.wav';
              $body_i['data']['is_accepted'] = 'N';
              $body_i['data']['message'] = "Order cancelled due to \"$order->cancellation_reason\"";
              $body_i['data']['alert'] = "Order cancelled due to \"$order->cancellation_reason\"";
              $body_i['data']['text'] = "Order cancelled due to \"$order->cancellation_reason\"";


              $user = Users::find()->where(['is_deleted'=>"N",'is_active'=>"Y",'id'=>$both_ids])->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->all();
              $device_token_android=$device_token_iphone=array();

                $ij=$mn=0;
                if(!empty($user)){
                    foreach ($user as $u_user) {
                      
                        $uDeviceDetail = Userdevices::find()->where(['user_id'=>$u_user->id])->orderby("last_login_datetime DESC")->all();

                        foreach ($uDeviceDetail as $u) {
                                   
                                if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                                {
                                    if($u->device_type=='a'|| $u->device_type=='A')
                                    {
                                        if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                            $ij++;
                                        $device_token_android[$ij][$u->access_token] = $u->device_id;
                                    }
                                    if($u->device_type=='i'|| $u->device_type=='I')
                                    {
                                        if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                            $mn++;
                                        $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                                    }
                                }
                              }
                    }
                }
                
            if($device_token_android != array())
                Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

            if($device_token_iphone != array())
                Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);
          
            

            $log=new Orderlog;
            $log->order_id=$order->id;
            $log->status=9;
            $log->is_read= 'Y';
            $log->i_by=$userId;
            $log->i_date=time();
            $log->save(false);     
            

            //Now save this record into user_master
            $rider = Users::findOne(yii::$app->user->id);
            $rider->no_of_order_cancel = $rider->no_of_order_cancel+1;
            $rider->is_available='Y';
            /**
             * Check if driver cancel request more then 2 then make inactive for
             * 24hrs and send notification to rider as well as vendor 
             */
            if(Yii::$app->common->checkCancelOrder()){
                $rider->is_active='N';
                $rider->active_time = strtotime('+1 day');
            }

            $rider->is_request_recieve = 'N';
            $rider->save(false);

            //send notifications to vendor and rider
           if($rider->is_active == 'N'){
               Yii::$app->common->sendBlockNotificationToRider($order);

           }
             
            return Yii::$app->apifunction->setResponse('order_cancel',true,200,200);        
            }
        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
    }//cancel order end here


    // 2- Pass , 3-Accept,4-Start,7-Delivered,8-Cancel by user,9-Cancel By rider
    public function actionChangestatus(){


        sleep(3);

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['order_id','type'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST))
        {
            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
             
            extract($_POST);
            $userId = yii::$app->user->id;

            if($type == '9'){
            $order_log = Orderlog::find()->where(['order_id'=>$order_id,'status'=>'9'])->one();
            if($order_log){
                return Yii::$app->apifunction->setResponse('allready_cancel',false,200,400);                 
             }
            }
            // if($type == '2'){
            // $order_log = Orderlog::find()->where(['order_id'=>$order_id,'status'=>'2'])->one();
            // if($order_log){
            //     return Yii::$app->apifunction->setResponse('allready_pass',false,200,400);                 
            //  }
            // }
            

            $order = Order::find()->where(['id'=>$order_id])->one();
            if(!$order){
                return Yii::$app->apifunction->setResponse('error_order_not_found',false,200,400);                 
            }
            /**
             * If pass then assigned this order to other rider
             */
            if($type == '2' && $order->status == '1'){

                /**
                 * send pass notification to vendor
                 */
              $noti = new Notification;
              $noti->from_user = Yii::$app->user->id;

            //   $both_ids[] = $order->user_id;
              $both_ids[] = $order->vendor_id;

              $noti->to_user = implode(',',$both_ids);

              $noti->notification_type = 'order_status';
              $noti->message = 'Order passed by the rider';
              $noti->type = 'V';
              $noti->i_by = Yii::$app->user->id;
              $noti->i_date = date('Y-m-d H:i:s');
              $noti->i_datetime = time();
              $noti->save(false);

              $body_a=array();
              $body_a['data']['notification_type'] = 'order_status';
              $body_a['data']['order_id'] = $order->id;
              $body_a['data']['master_id'] = $order->id;
              $body_a['data']['status'] = '2';
              $body_a['data']['message'] = 'Order passed by the rider';

              $body_i=array();
              $body_i['data'] = array('alert' =>'Order passed by the rider');
              $body_i['data']['badge'] = 1;
              $body_i['data']['status'] = '2';
              $body_i['data']['order_id'] = $order->id;
              $body_i['data']['master_id'] = $order->id;
              $body_i['data']['notification_type'] = 'order_status';
              $body_i['data']['sound'] = 'default';
              $body_i['data']['message'] = 'Order passed by the rider';
              $body_i['data']['alert'] = 'Order passed by the rider';
              $body_i['data']['text'] = 'Order passed by the rider';


              $user = Users::find()->where(['is_deleted'=>"N",'is_active'=>"Y",'id'=>$both_ids])->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->all();
              $device_token_android=$device_token_iphone=array();
                $ij=$mn=0;
                if(!empty($user)){
                    foreach ($user as $u_user) {
                     
                        $uDeviceDetail = Userdevices::find()->where(['user_id'=>$u_user->id])->orderby("last_login_datetime DESC")->all();

                            foreach ($uDeviceDetail as $u) {

                                if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                                {
                                    if($u->device_type=='a'|| $u->device_type=='A')
                                    {
                                        if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                            $ij++;
                                        $device_token_android[$ij][$u->access_token] = $u->device_id;
                                    }
                                    if($u->device_type=='i'|| $u->device_type=='I')
                                    {
                                        if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                            $mn++;
                                        $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                                    }
                                }
                              }
                    }
                }
                
            if($device_token_android != array())
                Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

            if($device_token_iphone != array())
                Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);

                $log=new Orderlog;
                $log->order_id=$order->id;
                $log->status= $type;
                $log->i_by=$userId;
                $log->i_date=time();
                $log->save(false);
   
                //Now save this record into user_master 
                // $rider = Users::findOne(yii::$app->user->id);
                $rider = Users::findOne($order->rider_id);
                $rider->no_of_order_passed = $rider->no_of_order_passed+1;
                $rider->is_request_recieve = 'N';
                $rider->is_available='Y';
                $rider->save(false);

                //We also find vendor of this rider and change the order status in vendor too
                $vendor = Users::findOne($rider->vendor_id);
                $vendor->no_of_order_passed += 1;
                $vendor->save(false);

                /**
                 * Here we have to find the rider of this vendor 
                 * If no rider found then find other vendor and its driver
                 * and assighned this order to them
                 */
                $sett_dis = Setting::find()->where(['key'=>'distance'])->one();
                if($sett_dis){
                    $distance   = $sett_dis->value;
                }
                else $distance = 10; //static distance 10km

                // (i) First find for this vendor
                $Vendor_lat_long = Users::find()->select(['id','latitude','longitude'])
                                                ->where(['id'=>$order->vendor_id])->one();

                $vendor_lat = $Vendor_lat_long->latitude;
                $vendor_long = $Vendor_lat_long->longitude;

                 $orders_log = Orderlog::find()->where(['order_id'=>$order->id])->all();
                 $dont_send = [];
                 if($orders_log){
                    $dont_send=ArrayHelper::map($orders_log,'i_by','i_by');
                 }

                //(ii) Here find the nearest rider and exclude those rider which are in order on the way
                $riders = Users::find()->select("*,( 3959 * acos( cos( radians($vendor_lat) ) * cos( radians( latitude) ) * cos( radians( longitude
                ) - radians($vendor_long) ) + sin( radians($vendor_lat) ) * sin( radians( latitude ) ) ) ) AS distance")
                                    ->where(['user_type'=>'R','is_deleted'=>'N','is_active'=>'Y','profile_status'=>'A','notification_enabled'=>'Y','is_available'=>'Y','is_request_recieve'=>'N','is_online'=>'Y','is_connected'=>'Y'])
                                    ->andWhere(['vendor_id'=>$Vendor_lat_long->id])
                                    ->andWhere(['NOT',['id'=>$order->rider_id]])
                                    ->andWhere(['NOT',['id'=>array_unique($dont_send)]])
                                    ->andWhere(['NOT',['latitude'=>null,'longitude'=>null]])
                                    ->andHaving("distance < $distance")->orderBy(['distance' => SORT_ASC])->one();
                                    
            if(empty($riders)){
                    // (ii) Find for other vendors

                    $previous_vendor = Vendorhistory::find()->where(['order_id'=>$order_id])
                                                            ->andWhere(['NOT',['vendor_id'=>$order->vendor_id]])
                                                            ->all();

                        foreach($previous_vendor as $new_vendor){

                            $Vendor_lat_long = Users::find()->select(['id','latitude','longitude'])
                                                            ->where(['id'=>$new_vendor->vendor_id])->one();
                            $vendor_lat = $Vendor_lat_long->latitude;
                            $vendor_long = $Vendor_lat_long->longitude;

                            $orders_log = Orderlog::find()->where(['order_id'=>$order->id])->all();
                            $dont_send = [];
                            if($orders_log){
                            $dont_send=ArrayHelper::map($orders_log,'i_by','i_by');
                            }


                            //(ii) Here find the nearest rider and exclude those rider which are in order process
                            $riders = Users::find()->select("*,( 3959 * acos( cos( radians($vendor_lat) ) * cos( radians( latitude) ) * cos( radians( longitude
                            ) - radians($vendor_long) ) + sin( radians($vendor_lat) ) * sin( radians( latitude ) ) ) ) AS distance")
                                            ->where(['user_type'=>'R','is_deleted'=>'N','is_active'=>'Y','profile_status'=>'A','notification_enabled'=>'Y','is_available'=>'Y','is_request_recieve'=>'N','is_online'=>'Y','is_connected'=>'Y'])
                                            ->andWhere(['vendor_id'=>$Vendor_lat_long->id])
                                            ->andWhere(['NOT',['id'=>array_unique($dont_send)]])
                                            ->andWhere(['NOT',['latitude'=>null,'longitude'=>null]])
                                            ->andHaving("distance < $distance")->orderBy(['distance' => SORT_ASC])->one();
                                            
                            // $order->vendor_id = $new_vendor->vendor_id;
                                

                            if(!empty($riders))
                            break;
                        }//foreach end here
            if(empty($riders)) {                             
                    /**
                     * Send one notification to user to notify about rider : rider not found
                     */
                    $noti = new Notification;
                    $noti->from_user = Yii::$app->user->id;

                    $noti->to_user = $order->user_id;
                    $noti->order_id = $order_id;
                    $noti->notification_type = 'no_rider_found';
                    $noti->message = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);
                    $noti->type = 'U';
                    
                    $noti->i_by = Yii::$app->user->id;
                    $noti->i_date = date('Y-m-d H:i:s');
                    $noti->i_datetime = time();
                    $noti->save(false);

                    $body_a=array();
                    $body_a['data']['notification_type'] = 'no_rider_found';
                    $body_a['data']['order_id'] = $order->id;
                    $body_a['data']['master_id'] = $order->id;
                    $body_a['data']['message'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);

                    $body_i=array();
                    $body_i['data'] = array('alert' =>Yii::t('app',Yii::$app->params['rider_not_available_for_order']));
                    $body_i['data']['badge'] = 1;
                    $body_i['data']['order_id'] = $order->id;
                    $body_i['data']['master_id'] = $order->id;
                    $body_i['data']['notification_type'] = 'no_rider_found';
                    $body_i['data']['sound'] = 'default';
                    $body_i['data']['message'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);
                    $body_i['data']['alert'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);
                    $body_i['data']['text'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);


                    $user = Users::find()->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->where(['is_deleted'=>"N",'is_active'=>"Y",'id'=> $order->user_id])->one();
                    $device_token_android=$device_token_iphone=array();
                        $ij=$mn=0;
                        if(!empty($user)){
                            
                                $uDeviceDetail = Userdevices::find()->where(['user_id'=>$user->id])->orderby("last_login_datetime DESC")->all();

                                    foreach ($uDeviceDetail as $u) {

                                        if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                                        {
                                            if($u->device_type=='a'|| $u->device_type=='A')
                                            {
                                                if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                                    $ij++;
                                                $device_token_android[$ij][$u->access_token] = $u->device_id;
                                            }
                                            if($u->device_type=='i'|| $u->device_type=='I')
                                            {
                                                if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                                    $mn++;
                                                $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                                            }
                                        }
                                      }
                            
                        }

                        if($device_token_android != array())
                         Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

                        if($device_token_iphone != array())
                            Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);
                        /**
                         * Here change the status of the orders,may be to cancel
                         */
                        $log=new Orderlog;
                        $log->order_id=$order->id;
                        $log->status= 10 ;
                        $log->i_by=yii::$app->user->id;
                        $log->i_date=time();
                        $log->save(false);
                        $order->timer=null;
                        $order->status=10; 
                        $order->save(false);       
                        OrderDetail::updateAll(['status' =>10], ['order_id' => $order->id]);
                      
                    return Yii::$app->apifunction->setResponse('rider_not_available',true,400,400);
                
                        
                }//rider emty condition end here
                
                $tmp_order = Order::find()->where(['id'=>$order_id])->one();
                if(!$tmp_order){
                    return Yii::$app->apifunction->setResponse('error_order_not_found',false,200,400);                 
                }


                if($tmp_order->status == '1'){

                 $order->rider_id = $riders->id;
                 $order->vendor_id = $riders->vendor_id;
                 //Now make order status ongoing


                  //Now save this record into user_master 
                $rider = Users::findOne($order->rider_id);
                $rider->is_request_recieve = 'Y';
                $rider->save(false);

                $order->status='1';
                $order->timer=time() + 51;

                 //Send notification new rider
                yii::$app->mycomponent->newOrderNotification($order);

                OrderDetail::updateAll(['status' =>$type], ['order_id' => $order->id]);

                $order->save(false);

             
            return Yii::$app->apifunction->setResponse('Success',true,200,200);


                }

            }
            //find for other vendors end here
                $order->rider_id = $riders->id;
                $order->vendor_id = $riders->vendor_id;


                //Now save this record into user_master 
                $rider = Users::findOne($order->rider_id);
                $rider->is_request_recieve = 'Y';
                $rider->save(false);

                 $order->status='1';
                 $order->timer=time() + 51;

                 //Send notification new rider
                yii::$app->mycomponent->newOrderNotification($order);

                OrderDetail::updateAll(['status' =>$type], ['order_id' => $order->id]);
        }//pass end here
            //Accept the order
            if($type == '3' && $order->status == '1'){
                $order->status='3';

                //Now save this record into user_master
                // $rider = Users::findOne(yii::$app->user->id);
                $rider = Users::findOne($order->rider_id);
                $rider->number_of_orders = $rider->number_of_orders+1;
                $rider->is_request_recieve = 'N';
                $rider->is_available='N';
                $rider->save(false);

                //We also find vendor of this rider and change the order status in vendor too
                $vendor = Users::findOne($rider->vendor_id);
                $vendor->number_of_orders += 1;
                $vendor->save(false);

                //(4) Finally decrese the stock from choosen vendor and do other processing

                $order_details = OrderDetail::find()->where(['order_id'=>$order->id])->all();
                foreach($order_details as $details){
                    $stock = Stock::find()->where(['user_id'=>$order->vendor_id,'product_id'=>$details->product_id])->one();
                    $stock->quantity = $stock->quantity - $details->quantity;
                    $stock->sold_out = $stock->sold_out + $details->quantity;
                    $stock->save(false);
                }

        /**
         * First of all i have to get all stocks 
         */
        $reminder = Userstock::find()->where(['user_id'=>$order->vendor_id])->one();

        if($reminder)
            $stocks = Stock::find()->where(['user_id'=>$reminder->user_id])
                         ->andwhere(['<=','quantity',$reminder->quantity])
                         ->all();
        if(isset($stocks) && $stocks){
            foreach($stocks as $stock){
                $new_stocks[] = $stock->product_id;
                }
            }
        
        if(isset($new_stocks) && $new_stocks){
            
              /** 
             * send stock notification to all vendors
             */
                $noti = new Notification;
                $noti->from_user = 0;
                $noti->to_user = $order->vendor_id;
                $noti->order_id = implode(',',$new_stocks);
                $noti->notification_type = 'stock_reminder';
                $noti->message = 'Product stock reminder notification';
                $noti->type = 'V';
                
                $noti->i_by = 0;
                $noti->i_date = date('Y-m-d H:i:s');
                $noti->i_datetime = time();
                $noti->save(false);

              $body_a=array();
              $body_a['data']['notification_type'] = 'stock_reminder';
              $body_a['data']['product_id'] =  implode(',',$new_stocks);
              $body_a['data']['message'] = 'Product stock reminder notification';

              $body_i=array();
              $body_i['data'] = array('alert' =>'Product stock reminder notification');
              $body_i['data']['badge'] = 1;
              $body_i['data']['product_id'] =  implode(',',$new_stocks);
              $body_i['data']['notification_type'] = 'stock_reminder';
              $body_i['data']['sound'] = 'default';
              $body_i['data']['message'] = 'Product stock reminder notification';
              $body_i['data']['alert'] = 'Product stock reminder notification';
              $body_i['data']['text'] = 'Product stock reminder notification';


              $user = Users::find()->where(['is_deleted'=>"N",'is_active'=>"Y",'notification_enabled'=>'Y','id'=>$order->vendor_id])->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->one();
              
              if($user){
                $ij=$mn=0;
              $uDeviceDetail = Userdevices::find()->where(['user_id'=>$user->id])->orderby("last_login_datetime DESC")->all();
                foreach ($uDeviceDetail as $u) {

                    if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                    {
                        if($u->device_type=='a'|| $u->device_type=='A')
                        {
                            if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                $ij++;
                            $device_token_android[$ij][$u->access_token] = $u->device_id;
                        }
                        if($u->device_type=='i'|| $u->device_type=='I')
                        {
                            if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                $mn++;
                            $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                        }
                    }
                  }
            }
    
            if($device_token_android != array())
            Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

            if($device_token_iphone != array())
            Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);
            //   if(!empty($uDeviceDetail))
            //   {
            //     if($uDeviceDetail['device_type'] == 'A')
            //     {
                
            //         yii::$app->common->pushnotification_android($uDeviceDetail['device_id'],$body_a);
            //     }
            //     if($uDeviceDetail['device_type'] == 'I')
            //     {
            //         yii::$app->common->pushnotification_iphone($uDeviceDetail['device_id'],$body_i);
            //     }
                  
            //   }

           
        }//if end of stocks
                      
                
                //From here I have to send Accept notification to User
                // And as well as it vendor if requierd
                    
                if(Users::find()->where(['id'=>$order->user_id])->one()){
                    yii::$app->mycomponent->sendnotificationtouser_accept($order);
                }

                OrderDetail::updateAll(['status' =>$type], ['order_id' => $order->id]);
                // yii::$app->mycomponent->sendnotificationtovendor($order);
          
            }

             //Start the order
             if($type == '4'){
                $order->status='4';

                //Now save this record into user_master
                // $rider = Users::findOne(yii::$app->user->id);
                // $rider->number_of_orders = $rider->number_of_orders+1;
                // $rider->save(false);

                //We also find vendor of this rider and change the order status in vendor too
                // $vendor = Users::findOne($rider->vendor_id);
                // $vendor->number_of_orders += 1;
                // $vendor->save(false);
                    
                if(Users::find()->where(['id'=>$order->user_id])->one()){
                    yii::$app->mycomponent->sendnotificationtouser_start($order);
                }

                OrderDetail::updateAll(['status' =>$type], ['order_id' => $order->id]);
                // yii::$app->mycomponent->sendnotificationtovendor($order);
                
                
                //From here I have to send Accept notification to User
                // And as well as it vendor if requierd
            }

            //Deliverd the order
            if($type == '7'){
                
                $order->status='7';
                $order->save(false);
                //Now save this record into user_master
                // $rider = Users::findOne(yii::$app->user->id);
                $rider = Users::findOne($order->rider_id);
                $rider->no_of_order_delivered = $rider->no_of_order_delivered+1;
                // if($order->payment_status == 'O')
                //     $rider->is_available='Y';
                $rider->save(false);

                //We also find vendor of this rider and change the order status in vendor too
                $vendor = Users::findOne($rider->vendor_id);
                $vendor->no_of_order_delivered += 1;
                $vendor->save(false);
                
                if(Users::find()->where(['id'=>$order->user_id])->one()){
                   yii::$app->mycomponent->sendnotificationtouser_deliverd($order);
                }
                OrderDetail::updateAll(['status' =>$type], ['order_id' => $order->id]);
                // yii::$app->mycomponent->sendnotificationtovendor($order);
                
                //From here I have to send Deliverd notification to User
                //And as well as Vendor if requierd


                /**
                 * Change the cancelation order status
                 */
                $order_log = Orderlog::find()->where(['i_by'=>$order->user_id,'status'=>'8','cancelation_charge'=>'Y'])->one();
                if($order_log){
                    $order_log->cancelation_charge = 'N';
                    $order_log->save(false);                 
                }
            }

            if($order->save(false))
            {

                $log=new Orderlog;
                $log->order_id=$order->id;
                $log->status= $type;
                if($type == 7)
                    $log->is_read= 'Y';
                $log->i_by=$userId;
                $log->i_date=time();
                $log->save(false);
            
            /**
             * Send notifications
             */
            // if(in_array($type,['3','4','7'])){
            //     if(Users::find()->where(['id'=>$order->user_id,'notification_enabled'=>'Y'])->one()){
            //         yii::$app->mycomponent->sendnotificationtouser($order);
            //         OrderDetail::updateAll(['status' =>$type], ['order_id' => $order->id]);
            //     }
            // }
             $message = 'order_status';
             
             if($type == 2)
             $message = 'order_pass';

             elseif($type == 3)
             $message = 'order_accept';

             elseif($type == 4)
             $message = 'order_start';

             elseif($type == 7)
             $message = 'order_deliver';

             elseif($type == 9)
             $message = 'order_cancel';
             
            return Yii::$app->apifunction->setResponse($message,true,200,200);        
            }
        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
    }//change order status end here



    public function actionReasonlist(){

            $this->layout=false;
            /*insert all required veriables*/
            $required_objs = [];

            //check user is guest or not
            Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            extract($_POST);

            //Lets  gets all reason list
           $reason = Reason::find()->where(['is_deleted'=>'N','is_active'=>'Y'])->all();
           if($reason){
           $i = 0;
           foreach ($reason as  $value) {
             $result['reason_list'][$i]['id'] = $value->id;
             $result['reason_list'][$i]['title'] = $value->reason;
             $result['reason_list'][$i]['is_other'] = $value->is_other;
             $i++;
           }
            return Yii::$app->apifunction->setResponse('success_reason_list',true,200,200,$result);
        }
        $result['reason_list'] = [];
        return Yii::$app->apifunction->setResponse('error_reason_list',true,200,400,$result);
                
     } //Reason end here


     public function actionReview(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = [];

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);
            $result['overall_rating'] = Users::findOne(yii::$app->user->id)->rating;
            $result['review_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id])->count();
            
            // $result['one_rate_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id,'is_deleted'=>'N'])->andwhere(['rating'=>1])->count();
            // $result['two_rate_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id,'is_deleted'=>'N'])->andwhere(['rating'=>2])->count();
            // $result['three_rate_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id,'is_deleted'=>'N'])->andwhere(['rating'=>3])->count();
            // $result['four_rate_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id,'is_deleted'=>'N'])->andwhere(['rating'=>4])->count();
            // $result['five_rate_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id,'is_deleted'=>'N'])->andwhere(['rating'=>5])->count();


            $result['one_rate_count']=   (int)Review::find()->where(['to_id'=>yii::$app->user->id])->andWhere(['between','rating', '0.5','1'])->count();
            $result['two_rate_count']=   (int)Review::find()->where(['to_id'=>yii::$app->user->id])->andWhere(['between','rating', '1.5','2'])->count();
            $result['three_rate_count']= (int)Review::find()->where(['to_id'=>yii::$app->user->id])->andWhere(['between','rating', '2.5','3'])->count();
            $result['four_rate_count']=  (int)Review::find()->where(['to_id'=>yii::$app->user->id])->andWhere(['between','rating', '3.5','4'])->count();
            $result['five_rate_count']=  (int)Review::find()->where(['to_id'=>yii::$app->user->id])->andWhere(['between','rating', '4.5','5'])->count();



        //Lets  gets all review  list
       $reviews = Review::find()->where(['to_id'=>yii::$app->user->id,'is_deleted'=>'N']);
        
        $start = isset($start) ? $start : 0  ;
        $limit  = isset($limit)  ? $limit+1  : 11 ;
        $reviews = $reviews->offset($start)->limit($limit);

        $reviews = $reviews->orderBy('id DESC')->all();

       if($reviews){
       $i = 0;
       foreach ($reviews as  $value) {
         $result['review_list_list'][$i]['review_id'] = $value->id;
         $result['review_list_list'][$i]['rate'] = (float)$value->rating;
         $result['review_list_list'][$i]['date'] = strtotime($value->i_date);
         $result['review_list_list'][$i]['review_description'] = isset($value->review)?$value->review:'';
         $i++;
       }
       
        $result['is_last'] ='Y';
        if($i > $limit){
            unset($result['review_list_list'][$i-1]);
            $result['is_last'] ='N';
        }

        return Yii::$app->apifunction->setResponse('review_list_list',true,200,200,$result);
    }
    $result['review_list_list'] = [];
    return Yii::$app->apifunction->setResponse('error_review_list_list',true,200,400,$result);
            
 } //Review list end here


    public function actionRating(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['rate','rider_id','comment'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){
        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
        extract($_POST);
        $userId = yii::$app->user->id;
     
        $review = new Review;
        $review->from_id=$userId;
        $review->to_id=$rider_id;
        $review->rating=$rate;
        if(isset($comment) && $comment!=null)
        {
          $review->review=$comment;
        }
       
        $review->i_by=$userId;
        $review->i_date=date("Y-m-d H:i:s");

        if($review->save(false))
        {
          $rider_sum=Review::find()->where(['to_id'=>$rider_id,'is_deleted'=>'N'])->sum('rating');
          $rider_cnt=Review::find()->where(['to_id'=>$rider_id,'is_deleted'=>'N'])->count();
          
          $rider=Users::findOne($rider_id);
          $rider->rating= ($rider_sum/$rider_cnt);
          $rider->save(false);

          return Yii::$app->apifunction->setResponse('thanks_feedback',true,200,200);
        }else{
          return Yii::$app->apifunction->setResponse('error_in_save',false,400,400);
        }
        }else{
          return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
      
    }//Rating done here

    public function actionAddtocart(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['is_refilling'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){
        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
        extract($_POST);
        $userId = yii::$app->user->id;
     
        $cart = new Cart;
        $cart->user_id    =$userId;
        $cart->product_id = isset($product_id)?$product_id:null;
        $cart->brand_id   = isset($brand_id)?$brand_id:null;
        $cart->vendor_id  = isset($vendor_id)?$vendor_id:null;
        $cart->quantity   = isset($quantity)?$quantity:null;
        $cart->is_refilling= $is_refilling;
        $cart->cylinder_size= isset($cylinder_size)?$cylinder_size:null;
        $cart->i_by   = $userId;
        $cart->i_date = time();

        if($cart->save(false))
        {
          return Yii::$app->apifunction->setResponse('success_cart_added',true,200,200);
        }else{
          return Yii::$app->apifunction->setResponse('error_in_save',false,400,400);
        }
        }else{
          return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
      
    }//Rating done here

    public function actionCartlist(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = [];

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

       //Now get those ids data
       $carts = Cart::find()->where(['user_id'=>yii::$app->user->id,'is_deleted'=>'N']);
  
       $start = isset($start) ? $start : 0  ;
       $limit  = isset($limit)  ? $limit+1  : 11 ;
       $carts = $carts->offset($start)->limit($limit);

       $carts = $carts->orderBy('id DESC')->all();
    
        if($carts){
            $i = 0;
        foreach ($carts as $key => $value) {
        $result['cart_item_list'][$i]['id'] = $value->id;

        $title = '';
        $image = '';
        $type = '';
        $price = 0;
            
         if($value->product_id!=null){
            $product = Product::find()->select(['id','title','product_type','price','is_deleted','brand_id'])->where(['id'=>$value->product_id,'is_deleted'=>'N'])->one();
            if($product){
            $title = $product->title;
            $image = Brand::find()->where(['id'=>$product->brand_id])->one()->brand_image;
            $type  = $product->product_type; 
            $price = number_format($product->price,2);
            }
        }elseif($value->brand_id!=null){
            $brand = Brand::find()->select(['id','brand_name','brand_image'])->where(['id'=>$value->brand_id])->one();
            if($brand){
            $title = $brand->brand_name;
            $image = $brand->brand_image;
            }
         }
        $result['cart_item_list'][$i]['title']  = $title;
        $result['cart_item_list'][$i]['image'] = ($image!='')?Url::to('@web/'.$image,true):'';
        $result['cart_item_list'][$i]['type'] = $type;
        $result['cart_item_list'][$i]['price'] = number_format($value->quantity*$price,2);
        $result['cart_item_list'][$i]['quantity'] = $value->quantity;
        
        $i++;
        }

        $result['is_last'] ='Y';
        if($i >= $limit){
            unset($result['cart_item_list'][$i-1]);
            $result['is_last'] ='N';
        }
        return Yii::$app->apifunction->setResponse('success_carts_list',true,200,200,$result);

        }else{
            $result['cart_item_list'] = [];           
        return Yii::$app->apifunction->setResponse('error_no_carts_found',true,200,200,$result);   
        }
    }//Cart list end here


    public function actionRemovecart(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['item_id'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){
        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
        extract($_POST);
        $userId = yii::$app->user->id;
     
        $cart = Cart::find()->where(['id'=>$item_id,'is_deleted'=>'N'])->one();
        if(!$cart){
          return Yii::$app->apifunction->setResponse('error_cart_not_found',false,400,400);            
        }
        $cart->is_deleted = 'Y' ;
        $cart->u_by   = $userId;
        $cart->u_date = time();

        if($cart->save(false))
        {
          return Yii::$app->apifunction->setResponse('success_cart_deleted',true,200,200);
        }else{
          return Yii::$app->apifunction->setResponse('error_in_save',false,400,400);
        }
        }else{
          return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
      
    }//Remove cart done here


    public function actionOrderdetail(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['order_id'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

        //First get all cylinder sizes from size_master table
        //$sizes = Size::find()->where(['is_deleted'=>'N','is_active'=>'Y'])->all();
        

    // $order = Order::find()->alias('O')->where(['user_id'=>yii::$app->user->id]);
       
       $order = Orderdetail::find()->alias('O')->where(['order_id'=>$order_id]);
       $order = $order->joinwith(['brand','product']);
  
       $start = isset($start) ? $start : 0  ;
       $limit  = isset($limit)  ? $limit+1  : 11 ;
       $order = $order->offset($start)->limit($limit);

       $order = $order->orderBy('id DESC')->all();
    
        if($order){
            $i = 0;
        foreach ($order as $key => $value) {
        $result['order_list'][$i]['order_id'] = $value->id;
        $result['order_list'][$i]['master_id'] = $value->order_id;
        $result['order_list'][$i]['order_date']  = $value->i_date;
        $result['order_list'][$i]['order_status'] = $value->status;
        
        /**
         * Change the title based on the parth and ankit suggestion
         */
        if($value->product->product_type == 'C')
          $title = 'Complete';

        if($value->product->product_type == 'O')
          $title = 'Outright';
        else
         $title = 'Refilling';
        

        $result['order_list'][$i]['title'] = $title;
        $result['order_list'][$i]['description'] = $value->product->title;
        $result['order_list'][$i]['size'] = $value->product->size;
        $result['order_list'][$i]['brand_name'] = $value->brand->brand_name;
        $result['order_list'][$i]['brand_image'] = $value->brand->brand_image?Url::to('@web/'.$value->brand->brand_image,true):'';
        $result['order_list'][$i]['quantity'] = $value->quantity;
        $result['order_list'][$i]['price'] = number_format($value->total_price,2);
        $i++;
        }
        /**
         * Get the status from Order master of payment 
         */
        if($order_status = Order::findOne($order_id)){
            $result['order_list']['payment_mode'] = $order_status->payment_status;
            $result['order_list']['payment_status'] = $order_status->is_payment_received;
            $result['order_list']['cancelation_charge'] = $order_status->cancellation_fee?$order_status->cancellation_fee:'';   
            $result['order_list']['cancellation_reason'] = isset($order_status->cancellation_reason)?$order_status->cancellation_reason:'';
            }

        

        $result['is_last'] ='Y';
        if($i >= $limit){
            unset($result['order_list'][$i-1]);
            $result['is_last'] ='N';
        }
        return Yii::$app->apifunction->setResponse('success_order_list',true,200,200,$result);

        }else{
            $result['order_list'] = [];           
        return Yii::$app->apifunction->setResponse('error_no_order_found',true,200,200,$result);   
        }
        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
    }//Order list end here


    public function actionOrdersummery(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['order_id'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

       $order_master = Order::find()->alias('O')->where(['O.id'=>$order_id/*,'status'=>['3','4','7','8','9']*/]);
        //    'rider_id'=>yii::$app->user->id,
       $order_master = $order_master->joinWith(['add'])->one();
       if($order_master){
           
       $result['order_id'] = $order_master->id;
       $result['order_time'] = $order_master->i_date;
       $result['payment_status'] = $order_master->is_payment_received;
       $result['payment_type'] = $order_master->payment_status;
       $result['order_status'] = $order_master->status;
       $result['order_price'] = number_format($order_master->total_price,2);
       $result['cancelation_charge'] = $order_master->cancellation_fee?$order_master->cancellation_fee:'';   
       $result['cancellation_reason'] = $order_master->cancellation_reason?$order_master->cancellation_reason:'';   
       

       $orders = OrderDetail::find()->where(['order_id'=>$order_id])
       ->joinWith(['product'])->all();
       $i = 0;
       foreach($orders as $order){
        
        $brand = $order->brand;

        $result['order_type_compelete'][$i]['title'] = $order->product->title;
        $result['order_type_compelete'][$i]['description'] = $order->product->title;
        $result['order_type_compelete'][$i]['size'] = $order->product->size;
        $result['order_type_compelete'][$i]['quantity'] = $order->quantity;

        $discount = $order->product_discount_percentage;
        if($discount>0){
            $result['order_type_compelete'][$i]['price']= number_format(($order->unit_price-($discount*$order->unit_price)/100),2);
        }else{
        $result['order_type_compelete'][$i]['price']= number_format($order->unit_price,2);
            
        }


        // $result['order_type_compelete'][$i]['price'] = number_format($order->unit_price,2);
        $result['order_type_compelete'][$i]['total_price'] = number_format($order->total_price-$order->product_discount_price,2);
        $result['order_type_compelete'][$i]['type'] = $order->product_type;

        $result['order_type_compelete'][$i]['brand_name']="";
        $result['order_type_compelete'][$i]['brand_image']="";
       
        if(isset($brand) && $brand !=null){
        $result['order_type_compelete'][$i]['brand_name']=$brand->brand_name;
        $result['order_type_compelete'][$i]['brand_image']=$brand->brand_image?Url::to('@web/'.$brand->brand_image,true):'';
        }

        $i++;
       }//foreach end here

       $i = 0;
       $result['price'][$i]['title'] = 'Sub Total';
       $result['price'][$i++]['price'] = number_format($order_master->base_price,2);

       $result['price'][$i]['title'] = 'Discount';
       $result['price'][$i++]['price'] = number_format($order_master->product_discount_price,2);

       $result['price'][$i]['title'] = 'Promo Code';
       $result['price'][$i++]['price'] = number_format(($order_master->base_price*$order_master->promocode_discount)/100,2);

       $result['price'][$i]['title'] = 'Total';
       $result['price'][$i++]['price'] = number_format($order_master->total_price,2);
        
       $result['user_info']['user_name'] = $order_master->add->full_name;  

       $str = '';
        if(isset($order_master->add->landmark) && $order_master->add->landmark !='')
            $str .= ', ' .$order_master->add->landmark.',';
        
        if(isset($order_master->add->area) && $order_master->add->area !='')
            $str .= ' ' .$order_master->add->area.',';
        

        if(isset($order_master->add->estate) && $order_master->add->estate !='')
            $str .= ' ' .$order_master->add->estate.',';

        if(isset($order_master->add->house_number) && $order_master->add->house_number !='') 
            $str .= ' ' .$order_master->add->house_number.',';

        
        if(isset($order_master->add->zipcode) && $order_master->add->zipcode !='')
            $str .= ' ' .$order_master->add->zipcode.'.';

       $result['user_info']['user_address'] = $order_master->add->address.$str;  

       $result['user_info']['landmark'] = isset($order_master->add->landmark)?$order_master->add->landmark:'';  
       $result['user_info']['area'] = isset($order_master->add->area)?$order_master->add->area:'';  
       $result['user_info']['house_number'] = isset($order_master->add->house_number)?$order_master->add->house_number:'';  
       $result['user_info']['zipcode'] = isset($order_master->add->zipcode)?$order_master->add->zipcode:'';  
       $result['user_info']['estate'] = isset($order_master->add->estate)?$order_master->add->estate:'';  
       
       $result['user_info']['mobile_number'] = $order_master->add->mobile_number;  
       $result['user_info']['country_code'] = $order_master->add->country_code;  
       $result['user_info']['latitude'] = $order_master->add->latitude;  
       $result['user_info']['longitude'] = $order_master->add->longitude;  
       $user_image = Users::findOne($order_master->user_id);
       $result['user_info']['user_image'] = $user_image->image?Url::to('@web/'.$user_image->image,true):'';  

       

    //    $order = OrderDetail::find()->alias('O')->where(['user_id'=>yii::$app->user->id,'order_id'=>$order_master->id]);
       
    //    $order = $order->joinwith(['brand','product']);

    //    $order = $order->orderBy('id DESC')->all();
    
       
        
        return Yii::$app->apifunction->setResponse('success_order_detail',true,200,200,$result);

        }else{
            $result['order_type_compelete'] = [];           
        return Yii::$app->apifunction->setResponse('error_no_order_found',true,200,200,$result);   
        }
        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
    }//Order summery end here

    public function actionOrderlist(){

        $timezone = Setting::find()->where(['key'=>'timezone'])->one()->value;
        yii::$app->timeZone = $timezone;
        
        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = ['is_cancel'];
        if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){

        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
        extract($_POST);

      
       $order = Order::find()->alias('O')->where(['rider_id'=>yii::$app->user->id]);
       $order = $order->joinWith(['customer']);

       if($is_cancel == 'Y')
         $order = $order->andWhere(['status'=>['9','8']]); //cancel by rider it self and user
       else 
         $order = $order->andWhere(['status'=>['3','4','7']]);

         if(isset($payment_mode) && $payment_mode != '')
            $order = $order->andWhere(['payment_status'=>$payment_mode]);
         

         if(isset($_POST['start_date']) && $_POST['start_date'] != null)
         {
            $start_date = date('Y-m-d',$_POST['start_date']);
            $start_date=strtotime($start_date.' 00:00:00');
            // $order = $order->andFilterWhere(['>=','O.i_date',$start_date]);
            $order = $order->andWhere(['>=','O.i_date',$start_date]);
         }

         if(isset($_POST['end_date']) && $_POST['end_date'] != null)
         {
           $end_date = date('Y-m-d',$_POST['end_date']);
           $end_date=strtotime($end_date.' 23:59:59');
        //    $order = $order->andFilterWhere(['<=','O.i_date',$end_date]);
           $order = $order->andWhere(['<=','O.i_date',$end_date]);
         }

        //  if(isset($_POST['start_date']) && $_POST['start_date'] != null && isset($_POST['end_date']) && $_POST['end_date'] != null)
        //  {
        //     $order = $order->where(['between', 'O.i_date', $start_date, $end_date ]);
        //  }
            
       
       $start = isset($start) ? $start : 0  ;
       $limit  = isset($limit)  ? $limit+1  : 11 ;
       $order = $order->offset($start)->limit($limit);

       $order = $order->orderBy('id DESC')->all();
       
        $i = 0; //globally so that other if can also use
        if($order){
           
        foreach ($order as $key => $value) {
        $result['order_list'][$i]['order_id'] = $value->id;
        $result['order_list'][$i]['order_date']  = $value->i_date;
        $result['order_list'][$i]['user_name']  = $value->add->full_name;
        $result['order_list'][$i]['user_image']  = $value->customer->image?Url::to('@web/'.$value->customer->image,true):'';
        
        $str = '';
       

        if(isset($value->add->landmark))
            $str .= ', ' .$value->add->landmark.',';


        if(isset($value->add->area) && $value->add->area !='')
            $str .= ' ' .$value->add->area.',';

        if(isset($value->add->estate))
            $str .= ' '.$value->add->estate.',';
        
        if(isset($value->add->house_number))
            $str .= ' '.$value->add->house_number.',';

        
        if(isset($value->add->zipcode))
            $str .= ' '.$value->add->zipcode.'.';

        $result['order_list'][$i]['user_address']  = $value->add->address.$str;
        $result['order_list'][$i]['order_status'] = $value->status;
        $result['order_list'][$i]['quantity'] = $value->total_quantity;
        $result['order_list'][$i]['total_price'] = number_format($value->total_price,2);
        $result['order_list'][$i]['price'] = number_format($value->base_price,2);
        /**
         *Payment mode will come from here
         * 
         */
        if(in_array( $value->payment_status,['C','O']))
         $result['order_list'][$i]['Payment_mode'] =  $value->payment_status=='C'?'Cash':'Online';
        else $result['order_list'][$i]['Payment_mode'] = 'Cash';
        
        $i++;
        }
        $result['is_last'] ='Y';
        if($i > $limit){
            unset($result['order_list'][$i-1]);
            $result['is_last'] ='N';
        }
       }//first if
        /**
         * Now here I have to find those order which cancel by rider or got cancel automatically
         * 
         */
        if($is_cancel == 'Y'){
            /** Here get order ids which are having status 8 by this rider */
            $order_ids = ArrayHelper::map(Orderlog::find()->where(['i_by'=>yii::$app->user->id,'status'=>['2','9','8']])->all(),'order_id','status');

            /** Now orders and there detail from above ids */

            $main_ids = array_keys($order_ids);
            // die(var_dump($main_ids));
            
            $order = Order::find()->alias('O')->where(['O.id'=>$main_ids]);
            $order = $order->joinWith(['customer']);
            
            if(isset($payment_mode) && $payment_mode != '')
            $order = $order->andWhere(['payment_status'=>$payment_mode]);
      

            if(isset($_POST['start_date']) && $_POST['start_date'] != null)
            {
                $start_date = date('Y-m-d',$_POST['start_date']);
                $start_date=strtotime($start_date.' 00:00:00');
                $order = $order->andFilterWhere(['>=','O.i_date',$start_date]);
            }

            if(isset($_POST['end_date']) && $_POST['end_date'] != null)
            {
                $end_date = date('Y-m-d',$_POST['end_date']);
                $end_date=strtotime($end_date.' 23:59:59');
                $order = $order->andFilterWhere(['<=','O.i_date',$end_date]);
            }
         
    
            $start = isset($start) ? $start : 0  ;
            $limit  = isset($limit)  ? $limit+1  : 11 ;
            $order = $order->offset($start)->limit($limit);

            $order = $order->orderBy('id DESC')->all();

            
            if($order){

            foreach ($order as $key => $value) {
            $result['order_list'][$i]['order_id'] = $value->id;
            $result['order_list'][$i]['order_date']  = $value->i_date;
            $result['order_list'][$i]['user_name']  = $value->add->full_name;
            $result['order_list'][$i]['user_image']  = $value->customer->image?Url::to('@web/'.$value->customer->image,true):'';
            
            $str = '';
        
            if(isset($value->add->landmark))
                $str .= ', ' .$value->add->landmark.',';

            if(isset($value->add->area) && $value->add->area !='')
                $str .= ' ' .$value->add->area.',';

            if(isset($value->add->estate))
                $str .= ' '.$value->add->estate.',';

            if(isset($value->add->house_number))
                $str .= ' '.$value->add->house_number.',';
            
            if(isset($value->add->zipcode))
                $str .= ' '.$value->add->zipcode.'.';

            
            $result['order_list'][$i]['user_address']  = $value->add->address.$str;
            
            /** My self retunr cancel status */
            $result['order_list'][$i]['order_status'] = isset($order_ids[$value->id])?$order_ids[$value->id]:'8';
            
            $result['order_list'][$i]['quantity'] = $value->total_quantity;
            $result['order_list'][$i]['total_price'] = number_format($value->total_price,2);
            $result['order_list'][$i]['price'] = number_format($value->base_price,2);
            /**
             *Payment mode will come from here
             * 
             */
            if(in_array( $value->payment_status,['C','O']))
             $result['order_list'][$i]['Payment_mode'] =  $value->payment_status=='C'?'Cash':'Online';
            else $result['order_list'][$i]['Payment_mode'] = 'Cash';
            
            $i++;
            }
            $result['is_last'] ='Y';
            if($i > $limit){
                unset($result['order_list'][$i-1]);
                $result['is_last'] ='N';
            }
           }

        }//is_cancel(second) if end here
        if(!empty($result['order_list'])){
        return Yii::$app->apifunction->setResponse('success_order_list',true,200,200,$result);
        }else{
              $result['order_list'] = [];           
        return Yii::$app->apifunction->setResponse('error_no_order_found',true,200,200,$result);   
        
        }
        }else{
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        }
    }//Order list end here

    public function actionDashboard(){

        $this->layout=false;
        /*insert all required veriables*/
        $required_objs = [];
        // if(Yii::$app->request->post() && Yii::$app->apifunction->checkIsPost($required_objs,$_POST)){
        //check user is guest or not
        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
        extract($_POST);
        $userId = yii::$app->user->id;
  
        $rider = Users::findOne($userId);
        $result['total_accepted_order'] = (int)$rider->number_of_orders;
        $result['total_canceled_order'] = (int)$rider->no_of_order_cancel;
        $result['total_delivered_order'] = (int)$rider->no_of_order_delivered;
        $result['total_passed_order'] = (int)$rider->no_of_order_passed;
        $result['is_profile_approved_by_admin'] = $rider->profile_status;

        /*
        Response param:
        1. status  > 3: accepted 4: started 7 : deliverd 
        2. job_data
        */

        // $order = Order::find()->where(['rider_id'=>yii::$app->user->id,'status'=>['3','4']])->orderBy('id desc')->one();
        $order = Order::find()->where(['rider_id'=>$userId,'status'=>['3','4']])->orWhere(['rider_id'=>$userId,'status'=>7,'is_payment_received'=>'N'])->orderBy('id desc')->one();

        if($order){
        $result['status'] = $order->status;
        $result['job_data']['order_id']= $order->id;
        $result['job_data']['payment_type']= $order->payment_status == 'C'?'Cash':'Online';
        $result['job_data']['order_price']= number_format($order->total_price,2);
        $result['job_data']['order_time']= $order->i_date;

        $result['job_data']['user_info']['user_id']= $order->user_id;
        $result['job_data']['user_info']['user_name'] = $order->add->full_name;
        $result['job_data']['user_info']['user_image']= $order->customer->image != ''?Url::to('@web/'.$order->customer->image,true):'';

        $str = '';
        $result['job_data']['time']= time();

        if($order->add->landmark !='')
            $str .= ', '.$order->add->landmark.', ';

        if($order->add->area != '')
            $str .= $order->add->area.', ';


        if($order->add->estate !='')
            $str .= $order->add->estate.', ';

        if($order->add->house_number !='')
            $str .= $order->add->house_number.'.';

        $result['job_data']['user_info']['user_address']=$order->add->address.$str;
        $result['job_data']['user_info']['latitude']=$order->add->latitude;
        $result['job_data']['user_info']['longitude']=$order->add->longitude;
        $result['job_data']['user_info']['mobile_number']=$order->add->country_code.' '.$order->add->mobile_number;

        $i=$j=$k=0;

        $result['job_data']['order_type_compelete'] = [];
        $result['job_data']['order_type_refilling'] = [];

        foreach($order->details as $detail){

         $brand = $detail->brand;

        if($detail->product_type == 'C' || $detail->product_type == 'O'){
        $result['job_data']['order_type_compelete'][$i]['title']=$detail->product->title;
        $result['job_data']['order_type_compelete'][$i]['description']=$detail->product->title;
        $result['job_data']['order_type_compelete'][$i]['quantity']=$detail->quantity;
        $discount = $detail->product_discount_percentage;
        if($discount>0){
            $result['job_data']['order_type_compelete'][$i]['price']= number_format(($detail->unit_price-($discount*$detail->unit_price)/100),2);
        }else{
        $result['job_data']['order_type_compelete'][$i]['price']= number_format($detail->unit_price,2);

        }

        $result['job_data']['order_type_compelete'][$i]['total_price']= number_format(($detail->total_price-$detail->product_discount_price),2);

        $result['job_data']['order_type_compelete'][$i]['discount_percentage'] = (float)$detail->product_discount_percentage;
        $result['job_data']['order_type_compelete'][$i]['discount'] = number_format($detail->product_discount_price,2);

        $result['job_data']['order_type_compelete'][$i]['brand_name']="";
        $result['job_data']['order_type_compelete'][$i]['brand_image']="";

        if(isset($brand) && $brand !=null){
        $result['job_data']['order_type_compelete'][$i]['brand_name']=$brand->brand_name;
        $result['job_data']['order_type_compelete'][$i]['brand_image']=$brand->brand_image?Url::to('@web/'.$brand->brand_image,true):'';
        }
        $i++;
        }//C if end here
        if($detail->product_type == 'R'){
        $result['job_data']['order_type_refilling'][$j]['title']=$detail->product->title;
        $result['job_data']['order_type_refilling'][$j]['description']=$detail->product->title;
        $result['job_data']['order_type_refilling'][$j]['quantity']=$detail->quantity;

        $discount = $detail->product_discount_percentage;
        if($discount>0){
            $result['job_data']['order_type_refilling'][$j]['price']= number_format(($detail->unit_price-($discount*$detail->unit_price)/100),2);
        }else{
        $result['job_data']['order_type_refilling'][$j]['price']= number_format($detail->unit_price,2);

        }
        $result['job_data']['order_type_refilling'][$j]['total_price']=number_format(($detail->total_price-$detail->product_discount_price),2);

        $result['job_data']['order_type_refilling'][$j]['discount_percentage'] = (float)$detail->product_discount_percentage;
        $result['job_data']['order_type_refilling'][$j]['discount'] = number_format($detail->product_discount_price,2);


        $result['job_data']['order_type_refilling'][$j]['brand_name']="";
        $result['job_data']['order_type_refilling'][$j]['brand_image']="";
        if(isset($brand) && $brand !=null){
        $result['job_data']['order_type_refilling'][$j]['brand_name']=$brand->brand_name;
        $result['job_data']['order_type_refilling'][$j]['brand_image']=$brand->brand_image?Url::to('@web/'.$brand->brand_image,true):'';
        }

        $j++;
        }

        }//for loop end here
        }else{
            $result['status'] = 0;
            $result['job_data'] = new Users;
        }


        return Yii::$app->apifunction->setResponse('dashboard_count',true,200,200,$result);
     
        // }else{
        //   return Yii::$app->apifunction->setResponse('response_text',false,400,400);
        // }
      
    }//Dashboard done here

    public function actionUpdateprofileimage(){

        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
        extract($_POST);
        $userId = yii::$app->user->id;
        $data = Users::findOne($userId);

        if(isset($_FILES['profile_image']['tmp_name']) && $_FILES['profile_image']['tmp_name'] != null)
        {
            /**
             * Unlink or delete the previouse image from server
             */
            if($data->image != null && file_exists(Yii::getAlias('@webroot').'/'.$data->image))
            {
                unlink(Yii::getAlias('@webroot')."/".$data->image);
            }

            $data->image = Yii::$app->apifunction->normalUpload($_FILES['profile_image'],yii::$app->params['user_direcotry']);
        
        
        //update driver detail
        
        
        $data->u_by = $data->id;
        // $data->u_date = date('Y-m-d H:i:s');
        $data->u_date = time();
        $data->save(false);

        $result['profile_image'] =  Url::to('@web/'.$data->image,true); 

        return Yii::$app->apifunction->setResponse('profile_successfully_updated',true,200,200,$result);
        
    }else{
              return Yii::$app->apifunction->setResponse('response_text',false,400,400);
            }

    }

    public function actionPaymentreceived(){

        Yii::$app->apifunction->checkLoggeduser(Yii::$app->user->identity->accessToken);
            
        extract($_POST);
        $userId = yii::$app->user->id;
        $data = Users::findOne($userId);

        if(isset($_REQUEST['order_id']) && $_REQUEST['order_id'] != null)
        {
            /**
             * Now from here make the payment statsu(is_payment_received) 'Y'(yes)
             */
            $order = Order::find()->where(['rider_id'=>Yii::$app->user->id,'id'=>(int) $_REQUEST['order_id']])->one();

            if($order){

            $order->is_payment_received = 'Y';
            $order->save(false);
                $result['order_id'] = $order->id;


                $rider = Users::findOne(yii::$app->user->id);
                $rider->is_available='Y';
                $rider->save(false);

              /** 
               * send payment notification to user as well as his vendor 
               */

              $noti = new Notification;
              $noti->from_user = Yii::$app->user->id;

              $both_ids[] = $order->user_id;
              $both_ids[] = $order->vendor_id;

              $noti->to_user = implode(',',$both_ids);

              $noti->notification_type = 'payment_status';
              $noti->message = "Rider has received Payment of order #$order->id";
              $noti->type = 'A';
              $noti->order_id = $_REQUEST['order_id'];
              $noti->i_by = Yii::$app->user->id;
              $noti->i_date = date('Y-m-d H:i:s');
              $noti->i_datetime = time();
              $noti->save(false);

              $body_a=array();
              $body_a['data']['notification_type'] = 'payment_status';
              $body_a['data']['order_id'] = $order->id;
              $body_a['data']['master_id'] = $order->id;
              $body_a['data']['status'] = $order->status;
              $body_a['data']['message'] = "Rider has received Payment of order #$order->id";

              $body_i=array();
              $body_i['data'] = array('alert' =>"Rider has received Payment of order #$order->id");
              $body_i['data']['badge'] = 1;
              $body_i['data']['order_id'] = $order->id;
              $body_i['data']['master_id'] = $order->id;
              $body_i['data']['status'] = $order->status;
              $body_i['data']['notification_type'] = 'payment_status';
              $body_i['data']['sound'] = 'default';
              $body_i['data']['message'] = "Rider has received Payment of order #$order->id";
              $body_i['data']['alert'] = "Rider has received Payment of order #$order->id";
              $body_i['data']['text'] = "Rider has received Payment of order #$order->id";


              $user = Users::find()->where(['is_deleted'=>"N",'is_active'=>"Y",'notification_enabled'=>'Y','id'=>$both_ids])->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->all();
              $device_token_android=$device_token_iphone=array();
                $ij=$mn=0;
                if(!empty($user)){
                    foreach ($user as $u_user) {
                     
                        $uDeviceDetail = Userdevices::find()->where(['user_id'=>$u_user->id])->orderby("last_login_datetime DESC")->all();


                           foreach ($uDeviceDetail as $u) {

                            if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                            {
                                if($u->device_type=='a'|| $u->device_type=='A')
                                {
                                    if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                        $ij++;
                                    $device_token_android[$ij][$u->access_token] = $u->device_id;
                                }
                                if($u->device_type=='i'|| $u->device_type=='I')
                                {
                                    if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                        $mn++;
                                    $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                                }
                            }
                          }
                    }
                }
            if($device_token_android != array())
                Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

            if($device_token_iphone != array())
                Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);


            return Yii::$app->apifunction->setResponse('Payment status change successfully',true,200,200,$result);
            
        }else{
              return Yii::$app->apifunction->setResponse('Order not found',false,400,400);                
            }

        
        }else{
              return Yii::$app->apifunction->setResponse('response_text',false,400,400);
            }
    }

    public function actionChangelocation(){

         $post = \Yii::$app->request->post();
  
         if(!(empty($post['latitude']) || empty($post['longitude']))){
  
          $userId = Yii::$app->user->identity->id;
          $data = Users::find()->where(['id'=>$userId,'user_type'=>'R','is_deleted'=>'N'])->one();
         if(!$data){
            return Yii::$app->apifunction->setResponse('Rider not found',false,400,400);         
          }
  
           if(isset($post['latitude']) && $post['latitude'] !=null)
            $data->latitude = $post['latitude'];
  
          if(isset($post['longitude']) && $post['longitude'] !=null)
            $data->longitude = $post['longitude'];
  
  
          // now save record in database
          if($data->save(false)){
            return Yii::$app->apifunction->setResponse('Location updated successfully',true,200,200);
          //While server error
          }
        //when bad request
        }else {
            return Yii::$app->apifunction->setResponse('response_text',false,400,400);
          }
      }//change location settings end here




    
    public function actionCronjob(){
        // Lets find all order those timer not null
        // Yii::$app->common->sendemail('qureshi@peerbits.com',"Faizan",$link="",'emailverify');
        
        // $orders = Order::find()->where(['is_deleted'=>'N','status'=>1])->all();

         $orders = Order::find()->where(['is_deleted'=>'N','status'=>1])->andwhere(['not',['timer'=>null]])->all();

                /**
                 * Here we have to find the rider of this vendor 
                 * If no rider found then find other vendor and its driver
                 * and assighned this order to them
                 */

        
        foreach($orders as $order){

               if($order->timer<= time())
              {
                $sett_dis = Setting::find()->where(['key'=>'distance'])->one();
                if($sett_dis){
                    $distance   = $sett_dis->value;
                }
                else $distance = 10; //static distance 10km

                // (i) First find for this vendor
                $Vendor_lat_long = Users::find()->select(['id','latitude','longitude'])
                                                ->where(['id'=>$order->vendor_id])->one();

                $vendor_lat = $Vendor_lat_long->latitude;
                $vendor_long = $Vendor_lat_long->longitude;

                $log=new Orderlog;
                $log->order_id=$order->id;
                $log->status= 1 ;
                $log->i_by= $order->rider_id;
                $log->i_date=time();
                $log->save(false);


                $orders_log = Orderlog::find()->where(['order_id'=>$order->id])->all();
                $dont_send = [];
                if($orders_log){
                   $dont_send=ArrayHelper::map($orders_log,'i_by','i_by');
                }

                
                //(ii) Here find the nearest rider and exclude those rider which are in order on the way
                $riders = Users::find()->select("*,( 3959 * acos( cos( radians($vendor_lat) ) * cos( radians( latitude) ) * cos( radians( longitude
                ) - radians($vendor_long) ) + sin( radians($vendor_lat) ) * sin( radians( latitude ) ) ) ) AS distance")
                                    ->where(['user_type'=>'R','is_deleted'=>'N','is_active'=>'Y','profile_status'=>'A','notification_enabled'=>'Y','is_available'=>'Y','is_request_recieve'=>'N','is_online'=>'Y','is_connected'=>'Y'])
                                    ->andWhere(['vendor_id'=>$Vendor_lat_long->id])
                                    ->andWhere(['NOT',['id'=>$order->rider_id]])
                                    ->andWhere(['NOT',['latitude'=>null,'longitude'=>null]])
                                    ->andWhere(['NOT',['id'=>array_unique($dont_send)]])
                                    ->andHaving("distance < $distance")->orderBy(['distance' => SORT_ASC])->one();
                                    
            if(empty($riders)){

                    // (ii) Find for other vendors


                    $previous_vendor = Vendorhistory::find()->where(['order_id'=>$order->id])
                                                            ->andWhere(['NOT',['vendor_id'=>$Vendor_lat_long->id]])
                                                            ->all();
                    // print_r($previous_vendor);die;
                    foreach($previous_vendor as $new_vendor){


                    	 $orders_log = Orderlog::find()->where(['order_id'=>$order->id])->all();
	                $dont_send = [];
	                if($orders_log){
	                   $dont_send=ArrayHelper::map($orders_log,'i_by','i_by');
	                }

                        // print_r($dont_send)

                        $Vendor_lat_long = Users::find()->select(['id','latitude','longitude'])
                                                        ->where(['id'=>$new_vendor->vendor_id])->one();
                        $vendor_lat = $Vendor_lat_long->latitude;
                        $vendor_long = $Vendor_lat_long->longitude;

                        //(ii) Here find the nearest rider and exclude those rider which are in order process
                        $riders = Users::find()->select("*,( 3959 * acos( cos( radians($vendor_lat) ) * cos( radians( latitude) ) * cos( radians( longitude
                        ) - radians($vendor_long) ) + sin( radians($vendor_lat) ) * sin( radians( latitude ) ) ) ) AS distance")
                                        ->where(['user_type'=>'R','is_deleted'=>'N','is_active'=>'Y','profile_status'=>'A','notification_enabled'=>'Y','is_available'=>'Y','is_available'=>'Y','is_request_recieve'=>'N','is_online'=>'Y','is_connected'=>'Y'])
                                        ->andWhere(['vendor_id'=>$Vendor_lat_long->id])
                                        // ->andWhere(['NOT',['id'=>isset($ids1)?$ids1:null]])
                                        ->andWhere(['NOT',['latitude'=>null,'longitude'=>null]])
                                        ->andWhere(['NOT',['id'=>array_unique($dont_send)]])
                                        ->andHaving("distance < $distance")->orderBy(['distance' => SORT_ASC])->one();
                                        
                        
                            

                        if(!empty($riders)){
                            /**
                             * Make is_request_recieve == N for old rider
                             */
                            $request_recieve = Users::findOne($order->rider_id);
                            if($request_recieve){
                                    $request_recieve->is_request_recieve = 'N';
                                    $request_recieve->is_available = 'Y';
                                    $request_recieve->save(false);
                            }

                             //Lets say rider 114 
                            $order->vendor_id = $riders->vendor_id;
                             $order->rider_id = $riders->id;
                             //Now make order status ongoing

                             /**
                              * For the temperory canceled the order later we will do this to original
                              */
                             $order->status='1';
                             $order->timer=time()+51;
                              // print_r($order);die;
                             $order->save(false); 

                             //Send notification new rider
                            yii::$app->mycomponent->newOrderNotification($order);

                            OrderDetail::updateAll(['status' =>$order->status], ['order_id' => $order->id]);

                                $log=new Orderlog;
                                $log->order_id=$order->id;
                                $log->status= 1 ;
                                $log->i_by= $order->rider_id;
                                $log->i_date=time();
                                $log->save(false);
                            /**
                             * Make is_request_recieve == Y for new rider
                             */
                            $request_recieve = Users::findOne($riders->id);
                            if($request_recieve){
                                    $request_recieve->is_request_recieve = 'Y';
                                    $request_recieve->save(false);
                            }
                            break;
                        }
                    }//foreach end here
                    //child if condition
            if(empty($riders)) {                                
                    /**
                     * Send one notification to user to notify about rider 
                     */
                    $noti = new Notification;
                    $noti->from_user = Yii::$app->user->id;

                    $noti->to_user = $order->user_id;

                    $noti->notification_type = 'no_rider_found';
                    $noti->message = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);
                    $noti->type = 'U';
                    
                    $noti->i_by = Yii::$app->user->id;
                    $noti->i_date = date('Y-m-d H:i:s');
                    $noti->i_datetime = time();
                    $noti->save(false);

                    $body_a=array();
                    $body_a['data']['notification_type'] = 'no_rider_found';
                    $body_a['data']['order_id'] = $order->id;
                    $body_a['data']['master_id'] = $order->id;
                    $body_a['data']['message'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);

                    $body_i=array();
                    $body_i['data'] = array('alert' =>Yii::t('app',Yii::$app->params['rider_not_available_for_order']));
                    $body_i['data']['badge'] = 1;
                    $body_i['data']['order_id'] = $order->id;
                    $body_i['data']['master_id'] = $order->id;
                    $body_i['data']['notification_type'] = 'no_rider_found';
                    $body_i['data']['sound'] = 'default';
                    $body_i['data']['message'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);
                    $body_i['data']['alert'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);
                    $body_i['data']['text'] = Yii::t('app',Yii::$app->params['rider_not_available_for_order']);


                    $user = Users::find()->where(['is_deleted'=>"N",'is_active'=>"Y",'notification_enabled'=>'Y','id'=> $order->user_id])->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->all();
                    $device_token_android=$device_token_iphone=array();
                        $ij=$mn=0;
                        if(!empty($user)){
                            foreach ($user as $u) {
                            
                                $uDeviceDetail = Userdevices::find()->where(['user_id'=>$u->id])->orderby("last_login_datetime DESC")->all();

                                    foreach ($uDeviceDetail as $u) {

                                        if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                                        {
                                            if($u->device_type=='a'|| $u->device_type=='A')
                                            {
                                                if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                                    $ij++;
                                                $device_token_android[$ij][$u->access_token] = $u->device_id;
                                            }
                                            if($u->device_type=='i'|| $u->device_type=='I')
                                            {
                                                if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                                    $mn++;
                                                $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                                            }
                                        }
                                      }
                            }
                        }

                        if($device_token_android != array())
                            Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

                        if($device_token_iphone != array())
                            Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);
                        /**
                         * Here change the status of the orders,may be to cancel
                         */
                        $log=new Orderlog;
                        $log->order_id=$order->id;
                        $log->status= 10 ;
                        $log->i_by=$order->rider_id;
                        $log->i_date=time();
                        $log->save(false);
                        $order->status=10;  
                        $order->timer=null;  
                        $order->save(false);   
                        
                        OrderDetail::updateAll(['status' =>10], ['order_id' => $order->id]);

		 				/**
		                 * Make is_request_recieve == N for old rider
		                 */
		                $request_recieve = Users::findOne($order->rider_id);
		                if($request_recieve){
		                        $request_recieve->is_request_recieve = 'N';
                                $request_recieve->is_available = 'Y';
		                        $request_recieve->save(false);
		                }

                      
                    return Yii::$app->apifunction->setResponse('rider_not_available',false,400,400);
                
                        
            }//rider empty of child condition end here
                

               

                return Yii::$app->apifunction->setResponse('Success',true,200,200);
                 

            }//empty parent if end here


                /**
                 * Make is_request_recieve == N for old rider
                 */
                $request_recieve = Users::findOne($order->rider_id);
                if($request_recieve){
                        $request_recieve->is_request_recieve = 'N';
                        $request_recieve->save(false);
                }


                $order->rider_id = $riders->id;
                 /**
                  * For the temperory canceled the order later we will do this to original
                  */
                 $order->status='1';
                 $order->timer=time() + 51;
                 $order->save(false); 



                $log=new Orderlog;
                $log->order_id=$order->id;
                $log->status= 1 ;
                $log->i_by= $order->rider_id;
                $log->i_date=time();
                $log->save(false);


                
                 //Send notification new rider
                yii::$app->mycomponent->newOrderNotification($order);


                OrderDetail::updateAll(['status' =>$order->status], ['order_id' => $order->id]);

                  /**
                 * Make is_request_recieve == Y for new rider
                 */
                $request_recieve = Users::findOne($riders->id);
                if($request_recieve){
                        $request_recieve->is_request_recieve = 'Y';
                        $request_recieve->save(false);
                }


                }//if end here
            }//foreach end here
        

    }


    public function actionCronjob_old_order(){
        //Lets find all order those timer not null
        // Yii::$app->common->sendemail('qureshi@peerbits.com',"Faizan",$link="",'emailverify');
        

        $yesterday = strtotime('-1 day');

        $orders = Order::find()->where(['is_deleted'=>'N','status'=>['1','3','4']])->andWhere(['<=','i_date',$yesterday])->all();
        // ->andwhere(['not',['status'=>['7','8','9']]])

                /**
                 * Here we have to find the rider of this vendor 
                 * If no rider found then find other vendor and its driver
                 * and assighned this order to them
                 */
        foreach($orders as $order){

                    $both_ids[] = $order->rider_id;
                    $both_ids[] = $order->vendor_id;
                    $both_ids[] = $order->user_id;

                    $noti = new Notification;
                    $noti->from_user = Yii::$app->user->id;

                    $noti->to_user = $order->user_id;

                    $noti->notification_type = 'no_rider_found';
                    $noti->message = 'Order has beed canceled';
                    $noti->type = 'A';
                    
                    $noti->i_by = Yii::$app->user->id;
                    $noti->i_date = date('Y-m-d H:i:s');
                    $noti->i_datetime = time();
                    $noti->save(false);

                    $body_a=array();
                    $body_a['data']['notification_type'] = 'no_rider_found';
                    $body_a['data']['order_id'] = $order->id;
                    $body_a['data']['master_id'] = $order->id;
                    $body_a['data']['message'] = 'Order has beed canceled';

                    $body_i=array();
                    $body_i['data'] = array('alert' =>'Order has beed canceled');
                    $body_i['data']['badge'] = 1;
                    $body_i['data']['order_id'] = $order->id;
                    $body_i['data']['master_id'] = $order->id;
                    $body_i['data']['notification_type'] = 'no_rider_found';
                    $body_i['data']['sound'] = 'default';
                    $body_i['data']['message'] = 'Order has beed canceled';
                    $body_i['data']['alert'] = 'Order has beed canceled';
                    $body_i['data']['text'] = 'Order has beed canceled';


                    $user = Users::find()->where(['is_deleted'=>"N",'is_active'=>"Y",'notification_enabled'=>'Y','id'=> $both_ids])->select(['id','is_deleted','is_active','user_type','notification_enabled','is_online'])->all();
                    $device_token_android=$device_token_iphone=array();
                        $ij=$mn=0;
                        if(!empty($user)){
                            foreach ($user as $u) {
                            
                                $uDeviceDetail = Userdevices::find()->where(['user_id'=>$u->id])->orderby("last_login_datetime DESC")->all();
                                    foreach ($uDeviceDetail as $u) {

                                        if(isset($u->device_id) && $u->device_id!=null && isset($u->device_type) && $u->device_type!=null)
                                        {
                                            if($u->device_type=='a'|| $u->device_type=='A')
                                            {
                                                if(isset($device_token_android[$ij]) && count($device_token_android[$ij]) == 500)
                                                    $ij++;
                                                $device_token_android[$ij][$u->access_token] = $u->device_id;
                                            }
                                            if($u->device_type=='i'|| $u->device_type=='I')
                                            {
                                                if(isset($device_token_iphone[$mn]) && count($device_token_iphone[$mn]) == 500)
                                                    $mn++;
                                                $device_token_iphone[$mn][$u->access_token] = $u->device_id;
                                            }
                                        }
                                      }
                            }
                        }

                        if($device_token_android != array())
                            Yii::$app->mycomponent->pushnotification_android_array($device_token_android,$body_a);

                        if($device_token_iphone != array())
                            Yii::$app->mycomponent->pushnotification_iphone_array($device_token_iphone,$body_i);
                        /**
                         * Here change the status of the orders,may be to cancel
                         */

                        /**
                         * Make is_request_recieve == N
                         */
                        $request_recieve = Users::findOne($order->rider_id);
                        if($request_recieve){
                                $request_recieve->is_request_recieve = 'N';
                                $request_recieve->save(false);
                        }

            
                        $log=new Orderlog;
                        $log->order_id=$order->id;
                        $log->status= 10 ;
                        $log->i_by=yii::$app->user->id;
                        $log->i_date=time();
                        $log->save(false);
                        $order->status=10;  
                        $order->timer=null;  
                        $order->save(false);    
                        OrderDetail::updateAll(['status' =>10], ['order_id' => $order->id]);
                      
                    // return Yii::$app->apifunction->setResponse('rider_not_available',false,400,400);
                
                        
                }//for loop end here
                return true;
    }

    public function actionUnblock_riders(){

    //  Yii::$app->common->sendemail('qureshi@peerbits.com',"Faizan",$link="",'emailverify');
     
     $total_inactive_riders = Users::find()->where(['is_deleted'=>'N','is_active'=>'N','user_type'=> ['R']])->andWhere(['NOT',['active_time'=>null]])->all();
    
     foreach($total_inactive_riders as $rider){

        if($rider->active_time <= time()){
        yii::$app->common->sendBlockNotificationToRiderOrVendor($rider);
        $rider->active_time = null;
        $rider->is_active = 'Y';
        $rider->save(false);
        }
     }
    }//unblock rider close here
}

